/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet.lift;

import be.tarsos.dsp.wavelet.lift.Daubechies4Wavelet;
import be.tarsos.dsp.wavelet.lift.HaarWavelet;
import be.tarsos.dsp.wavelet.lift.HaarWithPolynomialInterpolationWavelet;
import be.tarsos.dsp.wavelet.lift.LineWavelet;
import be.tarsos.dsp.wavelet.lift.PolynomialWavelets;

class LiftingSchemeTest {
    LiftingSchemeTest() {
    }

    private static void print(float[] fArray) {
        System.out.print("[");
        float[] fArray2 = fArray;
        int n = fArray2.length;
        for (int i = 0; i < n; ++i) {
            double d = fArray2[i];
            System.out.print(d);
            System.out.print(",");
        }
        System.out.println("]");
    }

    public static void main(String[] stringArray) {
        float[] fArray = new float[]{25.0f, 40.0f, 8.0f, 24.0f, 48.0f, 48.0f, 40.0f, 16.0f};
        HaarWavelet haarWavelet = new HaarWavelet();
        LineWavelet lineWavelet = new LineWavelet();
        Daubechies4Wavelet daubechies4Wavelet = new Daubechies4Wavelet();
        HaarWithPolynomialInterpolationWavelet haarWithPolynomialInterpolationWavelet = new HaarWithPolynomialInterpolationWavelet();
        PolynomialWavelets polynomialWavelets = new PolynomialWavelets();
        System.out.println("Data:");
        LiftingSchemeTest.print(fArray);
        System.out.println();
        System.out.println("HaarWavelet:");
        haarWavelet.forwardTrans(fArray);
        LiftingSchemeTest.print(fArray);
        System.out.println();
        haarWavelet.inverseTrans(fArray);
        LiftingSchemeTest.print(fArray);
        System.out.println();
        System.out.println("Daubechies4Wavelet:");
        daubechies4Wavelet.forwardTrans(fArray);
        LiftingSchemeTest.print(fArray);
        System.out.println();
        daubechies4Wavelet.inverseTrans(fArray);
        LiftingSchemeTest.print(fArray);
        System.out.println();
        System.out.println("Line:");
        lineWavelet.forwardTrans(fArray);
        LiftingSchemeTest.print(fArray);
        System.out.println();
        lineWavelet.inverseTrans(fArray);
        LiftingSchemeTest.print(fArray);
        System.out.println();
        System.out.println("HaarWavelet, extended with polynomial interpolation:");
        haarWithPolynomialInterpolationWavelet.forwardTrans(fArray);
        LiftingSchemeTest.print(fArray);
        System.out.println();
        haarWithPolynomialInterpolationWavelet.inverseTrans(fArray);
        LiftingSchemeTest.print(fArray);
        System.out.println();
        System.out.println("Poly:");
        polynomialWavelets.forwardTrans(fArray);
        LiftingSchemeTest.print(fArray);
        System.out.println();
        polynomialWavelets.inverseTrans(fArray);
        LiftingSchemeTest.print(fArray);
        System.out.println();
        float[] fArray2 = new float[]{56.0f, 40.0f, 8.0f, 24.0f, 48.0f, 48.0f, 40.0f, 16.0f};
        haarWavelet.forwardTransOne(fArray2);
        float[] fArray3 = new float[]{56.0f, 40.0f, 8.0f, 24.0f, 48.0f, 48.0f, 40.0f, 16.0f};
        LiftingSchemeTest.dwtHaar(fArray3);
    }

    private static void dwtHaar(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        float[] fArray3 = new float[fArray.length];
        for (int i = 0; i < fArray.length / 2; ++i) {
            fArray2[i] = (fArray[2 * i] + fArray[2 * i + 1]) / 2.0f;
            fArray3[i] = fArray[2 * i] - fArray2[i];
        }
        LiftingSchemeTest.print(fArray2);
        LiftingSchemeTest.print(fArray3);
    }
}

