/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet.lift;

class PolynomialInterpolation {
    private static final int numPts = 4;
    private float[][] fourPointTable = new float[4][4];
    private float[][] twoPointTable;

    private void lagrange(float f, int n, float[] fArray) {
        for (int i = 0; i < n; ++i) {
            float f2 = 1.0f;
            float f3 = 1.0f;
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                f2 *= f - (float)j;
                f3 *= (float)(i - j);
            }
            fArray[i] = f2 / f3;
        }
    }

    private void fillTable(int n, float[][] fArray) {
        float f = n;
        int n2 = 0;
        for (float f2 = 0.5f; f2 < f; f2 += 1.0f) {
            this.lagrange(f2, n, fArray[n2]);
            ++n2;
        }
    }

    public PolynomialInterpolation() {
        this.fillTable(4, this.fourPointTable);
        this.twoPointTable = new float[2][2];
        this.fillTable(2, this.twoPointTable);
    }

    private void printTable(float[][] fArray, int n) {
        System.out.println(n + "-point interpolation table:");
        double d = 0.5;
        for (int i = 0; i < n; ++i) {
            System.out.print(d + ": ");
            for (int j = 0; j < n; ++j) {
                System.out.print(fArray[i][j]);
                if (j >= n - 1) continue;
                System.out.print(", ");
            }
            System.out.println();
            d += 1.0;
        }
    }

    public void printTables() {
        this.printTable(this.fourPointTable, 4);
        this.printTable(this.twoPointTable, 2);
    }

    private void getCoef(float f, int n, float[] fArray) {
        float[][] fArray2 = null;
        int n2 = (int)f;
        if (n2 < 0 || n2 >= n) {
            System.out.println("PolynomialWavelets::getCoef: n = " + n + ", bad x value");
        }
        if (n == 4) {
            fArray2 = this.fourPointTable;
        } else if (n == 2) {
            fArray2 = this.twoPointTable;
            fArray[2] = 0.0f;
            fArray[3] = 0.0f;
        } else {
            System.out.println("PolynomialWavelets::getCoef: bad value for N");
        }
        if (fArray2 != null) {
            for (int i = 0; i < n; ++i) {
                fArray[i] = fArray2[n2][i];
            }
        }
    }

    public float interpPoint(float f, int n, float[] fArray) {
        float[] fArray2 = new float[4];
        float f2 = 0.0f;
        int n2 = 4;
        if (n < 4) {
            n2 = n;
        }
        this.getCoef(f, n2, fArray2);
        if (n2 == 4) {
            f2 = fArray2[0] * fArray[0] + fArray2[1] * fArray[1] + fArray2[2] * fArray[2] + fArray2[3] * fArray[3];
        } else if (n2 == 2) {
            f2 = fArray2[0] * fArray[0] + fArray2[1] * fArray[1];
        }
        return f2;
    }
}

