/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.wavelet.lift;

import be.tarsos.dsp.wavelet.lift.LiftingSchemeBaseWavelet;
import be.tarsos.dsp.wavelet.lift.PolynomialInterpolation;

public class PolynomialWavelets
extends LiftingSchemeBaseWavelet {
    static final int numPts = 4;
    private PolynomialInterpolation fourPt = new PolynomialInterpolation();

    private void fill(float[] fArray, float[] fArray2, int n, int n2) {
        int n3 = 4;
        if (n3 > n) {
            n3 = n;
        }
        int n4 = n2 + n3;
        int n5 = 0;
        for (int i = n2; i < n4; ++i) {
            fArray2[n5] = fArray[i];
            ++n5;
        }
    }

    @Override
    protected void update(float[] fArray, int n, int n2) {
        int n3 = n >> 1;
        for (int i = 0; i < n3; ++i) {
            int n4 = i + n3;
            if (n2 == 1) {
                fArray[i] = (fArray[i] + fArray[n4]) / 2.0f;
                continue;
            }
            if (n2 == 2) {
                fArray[i] = 2.0f * fArray[i] - fArray[n4];
                continue;
            }
            System.out.println("update: bad direction value");
        }
    }

    @Override
    protected void predict(float[] fArray, int n, int n2) {
        int n3 = n >> 1;
        float[] fArray2 = new float[4];
        for (int i = 0; i < n3; ++i) {
            float f;
            if (i == 0) {
                if (n3 == 1) {
                    f = fArray[0];
                } else {
                    this.fill(fArray, fArray2, n, 0);
                    f = this.fourPt.interpPoint(0.5f, n3, fArray2);
                }
            } else if (i == 1) {
                f = this.fourPt.interpPoint(1.5f, n3, fArray2);
            } else if (i == n3 - 2) {
                f = this.fourPt.interpPoint(2.5f, n3, fArray2);
            } else if (i == n3 - 1) {
                f = this.fourPt.interpPoint(3.5f, n3, fArray2);
            } else {
                this.fill(fArray, fArray2, n, i - 1);
                f = this.fourPt.interpPoint(1.5f, n3, fArray2);
            }
            int n4 = i + n3;
            if (n2 == 1) {
                fArray[n4] = fArray[n4] - f;
                continue;
            }
            if (n2 == 2) {
                fArray[n4] = fArray[n4] + f;
                continue;
            }
            System.out.println("PolynomialWavelets::predict: bad direction value");
        }
    }

    @Override
    public void forwardTrans(float[] fArray) {
        int n;
        for (int i = n = fArray.length; i > 1; i >>= 1) {
            this.split(fArray, i);
            this.update(fArray, i, 1);
            this.predict(fArray, i, 1);
        }
    }

    @Override
    public void inverseTrans(float[] fArray) {
        int n = fArray.length;
        for (int i = 2; i <= n; i <<= 1) {
            this.predict(fArray, i, 2);
            this.update(fArray, i, 2);
            this.merge(fArray, i);
        }
    }
}

