/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.writer;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.TarsosDSPAudioFormat;
import be.tarsos.dsp.writer.WaveHeader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WriterProcessor
implements AudioProcessor {
    RandomAccessFile output;
    TarsosDSPAudioFormat audioFormat;
    private int audioLen = 0;
    private static final int HEADER_LENGTH = 44;

    public WriterProcessor(TarsosDSPAudioFormat tarsosDSPAudioFormat, RandomAccessFile randomAccessFile) {
        this.output = randomAccessFile;
        this.audioFormat = tarsosDSPAudioFormat;
        try {
            randomAccessFile.write(new byte[44]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        try {
            this.audioLen += audioEvent.getByteBuffer().length;
            this.output.write(audioEvent.getByteBuffer());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    @Override
    public void processingFinished() {
        WaveHeader waveHeader = new WaveHeader(1, (short)this.audioFormat.getChannels(), (int)this.audioFormat.getSampleRate(), 16, this.audioLen);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            waveHeader.write(byteArrayOutputStream);
            this.output.seek(0L);
            this.output.write(byteArrayOutputStream.toByteArray());
            this.output.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

