/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.rarfile;

import de.innosystec.unrar.io.Raw;
import de.innosystec.unrar.rarfile.BaseBlock;
import de.innosystec.unrar.rarfile.UnrarHeadertype;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MarkHeader
extends BaseBlock {
    private Log logger = LogFactory.getLog((String)MarkHeader.class.getName());
    private boolean oldFormat = false;

    public MarkHeader(BaseBlock bb) {
        super(bb);
    }

    public boolean isValid() {
        if (this.getHeadCRC() != 24914) {
            return false;
        }
        if (this.getHeaderType() != UnrarHeadertype.MarkHeader) {
            return false;
        }
        if (this.getFlags() != 6689) {
            return false;
        }
        return this.getHeaderSize() == 7;
    }

    public boolean isSignature() {
        boolean valid = false;
        byte[] d = new byte[7];
        Raw.writeShortLittleEndian(d, 0, this.headCRC);
        d[2] = this.headerType;
        Raw.writeShortLittleEndian(d, 3, this.flags);
        Raw.writeShortLittleEndian(d, 5, this.headerSize);
        if (d[0] == 82) {
            if (d[1] == 69 && d[2] == 126 && d[3] == 94) {
                this.oldFormat = true;
                valid = true;
            } else if (d[1] == 97 && d[2] == 114 && d[3] == 33 && d[4] == 26 && d[5] == 7 && d[6] == 0) {
                this.oldFormat = false;
                valid = true;
            }
        }
        return valid;
    }

    public boolean isOldFormat() {
        return this.oldFormat;
    }

    public void print() {
        super.print();
        this.logger.info((Object)("valid: " + this.isValid()));
    }
}

