/*
 * Decompiled with CFR 0.152.
 */
package de.innosystec.unrar.unpack.ppm;

import de.innosystec.unrar.unpack.ppm.PPMContext;
import de.innosystec.unrar.unpack.ppm.RarMemBlock;
import de.innosystec.unrar.unpack.ppm.RarNode;
import java.util.Arrays;

public class SubAllocator {
    public static final int N1 = 4;
    public static final int N2 = 4;
    public static final int N3 = 4;
    public static final int N4 = 26;
    public static final int N_INDEXES = 38;
    public static final int UNIT_SIZE = Math.max(PPMContext.size, 12);
    public static final int FIXED_UNIT_SIZE = 12;
    private int subAllocatorSize;
    private int[] indx2Units = new int[38];
    private int[] units2Indx = new int[128];
    private int glueCount;
    private int heapStart;
    private int loUnit;
    private int hiUnit;
    private final RarNode[] freeList = new RarNode[38];
    private int pText;
    private int unitsStart;
    private int heapEnd;
    private int fakeUnitsStart;
    private byte[] heap;
    private int freeListPos;
    private int tempMemBlockPos;
    private RarNode tempRarNode = null;
    private RarMemBlock tempRarMemBlock1 = null;
    private RarMemBlock tempRarMemBlock2 = null;
    private RarMemBlock tempRarMemBlock3 = null;

    public SubAllocator() {
        this.clean();
    }

    public void clean() {
        this.subAllocatorSize = 0;
    }

    private void insertNode(int p, int indx) {
        RarNode temp = this.tempRarNode;
        temp.setAddress(p);
        temp.setNext(this.freeList[indx].getNext());
        this.freeList[indx].setNext(temp);
    }

    public void incPText() {
        ++this.pText;
    }

    private int removeNode(int indx) {
        int retVal = this.freeList[indx].getNext();
        RarNode temp = this.tempRarNode;
        temp.setAddress(retVal);
        this.freeList[indx].setNext(temp.getNext());
        return retVal;
    }

    private int U2B(int NU) {
        return UNIT_SIZE * NU;
    }

    private int MBPtr(int BasePtr, int Items) {
        return BasePtr + this.U2B(Items);
    }

    private void splitBlock(int pv, int oldIndx, int newIndx) {
        int uDiff = this.indx2Units[oldIndx] - this.indx2Units[newIndx];
        int p = pv + this.U2B(this.indx2Units[newIndx]);
        int i = this.units2Indx[uDiff - 1];
        if (this.indx2Units[i] != uDiff) {
            this.insertNode(p, --i);
            i = this.indx2Units[i];
            p += this.U2B(i);
            uDiff -= i;
        }
        this.insertNode(p, this.units2Indx[uDiff - 1]);
    }

    public void stopSubAllocator() {
        if (this.subAllocatorSize != 0) {
            this.subAllocatorSize = 0;
            this.heap = null;
            this.heapStart = 1;
            this.tempRarNode = null;
            this.tempRarMemBlock1 = null;
            this.tempRarMemBlock2 = null;
            this.tempRarMemBlock3 = null;
        }
    }

    public int GetAllocatedMemory() {
        return this.subAllocatorSize;
    }

    public boolean startSubAllocator(int SASize) {
        int realAllocSize;
        int t = SASize << 20;
        if (this.subAllocatorSize == t) {
            return true;
        }
        this.stopSubAllocator();
        int allocSize = t / 12 * UNIT_SIZE + UNIT_SIZE;
        this.tempMemBlockPos = realAllocSize = 1 + allocSize + 152;
        this.heap = new byte[realAllocSize += 12];
        this.heapStart = 1;
        this.heapEnd = this.heapStart + allocSize - UNIT_SIZE;
        this.subAllocatorSize = t;
        this.freeListPos = this.heapStart + allocSize;
        assert (realAllocSize - this.tempMemBlockPos == 12) : realAllocSize + " " + this.tempMemBlockPos + " " + 12;
        int i = 0;
        int pos = this.freeListPos;
        while (i < this.freeList.length) {
            this.freeList[i] = new RarNode(this.heap);
            this.freeList[i].setAddress(pos);
            ++i;
            pos += 4;
        }
        this.tempRarNode = new RarNode(this.heap);
        this.tempRarMemBlock1 = new RarMemBlock(this.heap);
        this.tempRarMemBlock2 = new RarMemBlock(this.heap);
        this.tempRarMemBlock3 = new RarMemBlock(this.heap);
        return true;
    }

    private void glueFreeBlocks() {
        int i;
        RarMemBlock s0 = this.tempRarMemBlock1;
        s0.setAddress(this.tempMemBlockPos);
        RarMemBlock p = this.tempRarMemBlock2;
        RarMemBlock p1 = this.tempRarMemBlock3;
        if (this.loUnit != this.hiUnit) {
            this.heap[this.loUnit] = 0;
        }
        s0.setPrev(s0);
        s0.setNext(s0);
        for (i = 0; i < 38; ++i) {
            while (this.freeList[i].getNext() != 0) {
                p.setAddress(this.removeNode(i));
                p.insertAt(s0);
                p.setStamp(65535);
                p.setNU(this.indx2Units[i]);
            }
        }
        p.setAddress(s0.getNext());
        while (p.getAddress() != s0.getAddress()) {
            p1.setAddress(this.MBPtr(p.getAddress(), p.getNU()));
            while (p1.getStamp() == 65535 && p.getNU() + p1.getNU() < 65536) {
                p1.remove();
                p.setNU(p.getNU() + p1.getNU());
                p1.setAddress(this.MBPtr(p.getAddress(), p.getNU()));
            }
            p.setAddress(p.getNext());
        }
        p.setAddress(s0.getNext());
        while (p.getAddress() != s0.getAddress()) {
            int sz;
            p.remove();
            for (sz = p.getNU(); sz > 128; sz -= 128) {
                this.insertNode(p.getAddress(), 37);
                p.setAddress(this.MBPtr(p.getAddress(), 128));
            }
            i = this.units2Indx[sz - 1];
            if (this.indx2Units[i] != sz) {
                int k = sz - this.indx2Units[--i];
                this.insertNode(this.MBPtr(p.getAddress(), sz - k), k - 1);
            }
            this.insertNode(p.getAddress(), i);
            p.setAddress(s0.getNext());
        }
    }

    private int allocUnitsRare(int indx) {
        if (this.glueCount == 0) {
            this.glueCount = 255;
            this.glueFreeBlocks();
            if (this.freeList[indx].getNext() != 0) {
                return this.removeNode(indx);
            }
        }
        int i = indx;
        do {
            if (++i != 38) continue;
            --this.glueCount;
            i = this.U2B(this.indx2Units[indx]);
            int j = 12 * this.indx2Units[indx];
            if (this.fakeUnitsStart - this.pText > j) {
                this.fakeUnitsStart -= j;
                this.unitsStart -= i;
                return this.unitsStart;
            }
            return 0;
        } while (this.freeList[i].getNext() == 0);
        int retVal = this.removeNode(i);
        this.splitBlock(retVal, i, indx);
        return retVal;
    }

    public int allocUnits(int NU) {
        int indx = this.units2Indx[NU - 1];
        if (this.freeList[indx].getNext() != 0) {
            return this.removeNode(indx);
        }
        int retVal = this.loUnit;
        this.loUnit += this.U2B(this.indx2Units[indx]);
        if (this.loUnit <= this.hiUnit) {
            return retVal;
        }
        this.loUnit -= this.U2B(this.indx2Units[indx]);
        return this.allocUnitsRare(indx);
    }

    public int allocContext() {
        if (this.hiUnit != this.loUnit) {
            return this.hiUnit -= UNIT_SIZE;
        }
        if (this.freeList[0].getNext() != 0) {
            return this.removeNode(0);
        }
        return this.allocUnitsRare(0);
    }

    public int expandUnits(int oldPtr, int OldNU) {
        int i0 = this.units2Indx[OldNU - 1];
        int i1 = this.units2Indx[OldNU - 1 + 1];
        if (i0 == i1) {
            return oldPtr;
        }
        int ptr = this.allocUnits(OldNU + 1);
        if (ptr != 0) {
            System.arraycopy(this.heap, oldPtr, this.heap, ptr, this.U2B(OldNU));
            this.insertNode(oldPtr, i0);
        }
        return ptr;
    }

    public int shrinkUnits(int oldPtr, int oldNU, int newNU) {
        int i0 = this.units2Indx[oldNU - 1];
        int i1 = this.units2Indx[newNU - 1];
        if (i0 == i1) {
            return oldPtr;
        }
        if (this.freeList[i1].getNext() != 0) {
            int ptr = this.removeNode(i1);
            System.arraycopy(this.heap, oldPtr, this.heap, ptr, this.U2B(newNU));
            this.insertNode(oldPtr, i0);
            return ptr;
        }
        this.splitBlock(oldPtr, i0, i1);
        return oldPtr;
    }

    public void freeUnits(int ptr, int OldNU) {
        this.insertNode(ptr, this.units2Indx[OldNU - 1]);
    }

    public int getFakeUnitsStart() {
        return this.fakeUnitsStart;
    }

    public void setFakeUnitsStart(int fakeUnitsStart) {
        this.fakeUnitsStart = fakeUnitsStart;
    }

    public int getHeapEnd() {
        return this.heapEnd;
    }

    public int getPText() {
        return this.pText;
    }

    public void setPText(int text) {
        this.pText = text;
    }

    public void decPText(int dPText) {
        this.setPText(this.getPText() - dPText);
    }

    public int getUnitsStart() {
        return this.unitsStart;
    }

    public void setUnitsStart(int unitsStart) {
        this.unitsStart = unitsStart;
    }

    public void initSubAllocator() {
        Arrays.fill(this.heap, this.freeListPos, this.freeListPos + this.sizeOfFreeList(), (byte)0);
        this.pText = this.heapStart;
        int size2 = 12 * (this.subAllocatorSize / 8 / 12 * 7);
        int realSize2 = size2 / 12 * UNIT_SIZE;
        int size1 = this.subAllocatorSize - size2;
        int realSize1 = size1 / 12 * UNIT_SIZE + size1 % 12;
        this.hiUnit = this.heapStart + this.subAllocatorSize;
        this.loUnit = this.unitsStart = this.heapStart + realSize1;
        this.fakeUnitsStart = this.heapStart + size1;
        this.hiUnit = this.loUnit + realSize2;
        int i = 0;
        int k = 1;
        while (i < 4) {
            this.indx2Units[i] = k & 0xFF;
            ++i;
            ++k;
        }
        ++k;
        while (i < 8) {
            this.indx2Units[i] = k & 0xFF;
            ++i;
            k += 2;
        }
        ++k;
        while (i < 12) {
            this.indx2Units[i] = k & 0xFF;
            ++i;
            k += 3;
        }
        ++k;
        while (i < 38) {
            this.indx2Units[i] = k & 0xFF;
            ++i;
            k += 4;
        }
        this.glueCount = 0;
        i = 0;
        for (k = 0; k < 128; ++k) {
            this.units2Indx[k] = (i += this.indx2Units[i] < k + 1 ? 1 : 0) & 0xFF;
        }
    }

    private int sizeOfFreeList() {
        return this.freeList.length * 4;
    }

    public byte[] getHeap() {
        return this.heap;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SubAllocator[");
        buffer.append("\n  subAllocatorSize=");
        buffer.append(this.subAllocatorSize);
        buffer.append("\n  glueCount=");
        buffer.append(this.glueCount);
        buffer.append("\n  heapStart=");
        buffer.append(this.heapStart);
        buffer.append("\n  loUnit=");
        buffer.append(this.loUnit);
        buffer.append("\n  hiUnit=");
        buffer.append(this.hiUnit);
        buffer.append("\n  pText=");
        buffer.append(this.pText);
        buffer.append("\n  unitsStart=");
        buffer.append(this.unitsStart);
        buffer.append("\n]");
        return buffer.toString();
    }
}

