/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.vget.vhs;

import com.github.axet.vget.info.VGetParser;
import com.github.axet.vget.info.VideoFileInfo;
import com.github.axet.vget.info.VideoInfo;
import com.github.axet.vget.vhs.YouTubeInfo;
import com.github.axet.wget.WGet;
import com.github.axet.wget.info.ex.DownloadError;
import com.github.axet.wget.info.ex.DownloadRetry;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class YouTubeParser
extends VGetParser {
    static final String UTF8 = "UTF-8";
    static final Map<Integer, YouTubeInfo.StreamInfo> itagMap = new HashMap<Integer, YouTubeInfo.StreamInfo>(){
        private static final long serialVersionUID = -6925194111122038477L;
        {
            this.put(120, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.FLV, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p720, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k128));
            this.put(102, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP8, YouTubeInfo.YoutubeQuality.p720, YouTubeInfo.Encoding.VORBIS, YouTubeInfo.AudioQuality.k192));
            this.put(101, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP8, YouTubeInfo.YoutubeQuality.p360, YouTubeInfo.Encoding.VORBIS, YouTubeInfo.AudioQuality.k192));
            this.put(100, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP8, YouTubeInfo.YoutubeQuality.p360, YouTubeInfo.Encoding.VORBIS, YouTubeInfo.AudioQuality.k128));
            this.put(85, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p1080, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k192));
            this.put(84, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p720, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k192));
            this.put(83, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p240, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k96));
            this.put(82, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p360, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k96));
            this.put(46, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP8, YouTubeInfo.YoutubeQuality.p1080, YouTubeInfo.Encoding.VORBIS, YouTubeInfo.AudioQuality.k192));
            this.put(45, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP8, YouTubeInfo.YoutubeQuality.p720, YouTubeInfo.Encoding.VORBIS, YouTubeInfo.AudioQuality.k192));
            this.put(44, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP8, YouTubeInfo.YoutubeQuality.p480, YouTubeInfo.Encoding.VORBIS, YouTubeInfo.AudioQuality.k128));
            this.put(43, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP8, YouTubeInfo.YoutubeQuality.p360, YouTubeInfo.Encoding.VORBIS, YouTubeInfo.AudioQuality.k128));
            this.put(38, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p3072, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k192));
            this.put(37, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p1080, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k192));
            this.put(36, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.GP3, YouTubeInfo.Encoding.MP4, YouTubeInfo.YoutubeQuality.p240, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k36));
            this.put(35, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.FLV, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p480, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k128));
            this.put(34, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.FLV, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p360, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k128));
            this.put(22, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p720, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k192));
            this.put(18, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p360, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k96));
            this.put(17, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.GP3, YouTubeInfo.Encoding.MP4, YouTubeInfo.YoutubeQuality.p144, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k24));
            this.put(6, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.FLV, YouTubeInfo.Encoding.H263, YouTubeInfo.YoutubeQuality.p270, YouTubeInfo.Encoding.MP3, YouTubeInfo.AudioQuality.k64));
            this.put(5, new YouTubeInfo.StreamCombined(YouTubeInfo.Container.FLV, YouTubeInfo.Encoding.H263, YouTubeInfo.YoutubeQuality.p240, YouTubeInfo.Encoding.MP3, YouTubeInfo.AudioQuality.k64));
            this.put(133, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p240));
            this.put(134, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p360));
            this.put(135, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p480));
            this.put(136, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p720));
            this.put(137, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p1080));
            this.put(138, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p2160));
            this.put(160, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p144));
            this.put(242, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP9, YouTubeInfo.YoutubeQuality.p240));
            this.put(243, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP9, YouTubeInfo.YoutubeQuality.p360));
            this.put(244, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP9, YouTubeInfo.YoutubeQuality.p480));
            this.put(247, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP9, YouTubeInfo.YoutubeQuality.p720));
            this.put(248, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP9, YouTubeInfo.YoutubeQuality.p1080));
            this.put(264, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p1440));
            this.put(271, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP9, YouTubeInfo.YoutubeQuality.p1440));
            this.put(272, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP9, YouTubeInfo.YoutubeQuality.p2160));
            this.put(278, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP9, YouTubeInfo.YoutubeQuality.p144));
            this.put(298, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p720));
            this.put(299, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.H264, YouTubeInfo.YoutubeQuality.p1080));
            this.put(302, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP9, YouTubeInfo.YoutubeQuality.p720));
            this.put(303, new YouTubeInfo.StreamVideo(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VP9, YouTubeInfo.YoutubeQuality.p1080));
            this.put(139, new YouTubeInfo.StreamAudio(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k48));
            this.put(140, new YouTubeInfo.StreamAudio(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k128));
            this.put(141, new YouTubeInfo.StreamAudio(YouTubeInfo.Container.MP4, YouTubeInfo.Encoding.AAC, YouTubeInfo.AudioQuality.k256));
            this.put(171, new YouTubeInfo.StreamAudio(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VORBIS, YouTubeInfo.AudioQuality.k128));
            this.put(172, new YouTubeInfo.StreamAudio(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.VORBIS, YouTubeInfo.AudioQuality.k192));
            this.put(249, new YouTubeInfo.StreamAudio(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.OPUS, YouTubeInfo.AudioQuality.k50));
            this.put(250, new YouTubeInfo.StreamAudio(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.OPUS, YouTubeInfo.AudioQuality.k70));
            this.put(251, new YouTubeInfo.StreamAudio(YouTubeInfo.Container.WEBM, YouTubeInfo.Encoding.OPUS, YouTubeInfo.AudioQuality.k160));
        }
    };

    public static boolean probe(URL url) {
        return url.toString().contains("youtube.com");
    }

    public List<VideoDownload> extractLinks(YouTubeInfo info) {
        return this.extractLinks(info, new AtomicBoolean(), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public List<VideoDownload> extractLinks(YouTubeInfo info, AtomicBoolean stop, Runnable notify) {
        try {
            ArrayList<VideoDownload> sNextVideoURL = new ArrayList<VideoDownload>();
            try {
                this.streamCapture(sNextVideoURL, info, stop, notify);
            }
            catch (DownloadError e) {
                try {
                    this.extractEmbedded(sNextVideoURL, info, stop, notify);
                }
                catch (EmbeddingDisabled ee) {
                    throw e;
                }
            }
            return sNextVideoURL;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void streamCapture(List<VideoDownload> sNextVideoURL, final YouTubeInfo info, AtomicBoolean stop, final Runnable notify) throws Exception {
        String html = WGet.getHtml((URL)info.getWeb(), (WGet.HtmlLoader)new WGet.HtmlLoader(){

            public void notifyRetry(int delay, Throwable e) {
                info.setRetrying(delay, e);
                notify.run();
            }

            public void notifyDownloading() {
                info.setState(VideoInfo.States.DOWNLOADING);
                notify.run();
            }

            public void notifyMoved() {
                info.setState(VideoInfo.States.RETRYING);
                notify.run();
            }
        }, (AtomicBoolean)stop);
        this.extractHtmlInfo(sNextVideoURL, info, html, stop, notify);
        this.extractIcon(info, html);
    }

    void filter(List<VideoDownload> sNextVideoURL, String itag, URL url) {
        Integer i = Integer.decode(itag);
        YouTubeInfo.StreamInfo vd = itagMap.get(i);
        sNextVideoURL.add(new VideoDownload(vd, url));
    }

    public static String extractId(URL url) {
        Pattern u = Pattern.compile("youtube.com/watch?.*v=([^&]*)");
        Matcher um = u.matcher(url.toString());
        if (um.find()) {
            return um.group(1);
        }
        u = Pattern.compile("youtube.com/v/([^&]*)");
        um = u.matcher(url.toString());
        if (um.find()) {
            return um.group(1);
        }
        return null;
    }

    void extractEmbedded(List<VideoDownload> sNextVideoURL, final YouTubeInfo info, AtomicBoolean stop, final Runnable notify) throws Exception {
        String id = YouTubeParser.extractId(info.getWeb());
        if (id == null) {
            throw new RuntimeException("unknown url");
        }
        info.setTitle(String.format("https://www.youtube.com/watch?v=%s", id));
        String get = String.format("https://www.youtube.com/get_video_info?authuser=0&video_id=%s&el=embedded", id);
        URL url = new URL(get);
        String qs = WGet.getHtml((URL)url, (WGet.HtmlLoader)new WGet.HtmlLoader(){

            public void notifyRetry(int delay, Throwable e) {
                info.setRetrying(delay, e);
                notify.run();
            }

            public void notifyDownloading() {
                info.setState(VideoInfo.States.DOWNLOADING);
                notify.run();
            }

            public void notifyMoved() {
                info.setState(VideoInfo.States.RETRYING);
                notify.run();
            }
        }, (AtomicBoolean)stop);
        Map<String, String> map = YouTubeParser.getQueryMap(qs);
        if (map.get("status").equals("fail")) {
            String r = URLDecoder.decode(map.get("reason"), UTF8);
            if (map.get("errorcode").equals("150")) {
                throw new EmbeddingDisabled("error code 150");
            }
            if (map.get("errorcode").equals("100")) {
                throw new VideoDeleted("error code 100");
            }
            throw new DownloadError(r);
        }
        info.setTitle(URLDecoder.decode(map.get("title"), UTF8));
        String url_encoded_fmt_stream_map = URLDecoder.decode(map.get("url_encoded_fmt_stream_map"), UTF8);
        this.extractUrlEncodedVideos(sNextVideoURL, url_encoded_fmt_stream_map, info, stop, notify);
        String icon = map.get("thumbnail_url");
        icon = URLDecoder.decode(icon, UTF8);
        info.setIcon(new URL(icon));
    }

    void extractIcon(VideoInfo info, String html) {
        try {
            Pattern title = Pattern.compile("itemprop=\"thumbnailUrl\" href=\"(.*)\"");
            Matcher titleMatch = title.matcher(html);
            if (titleMatch.find()) {
                String sline = titleMatch.group(1);
                sline = StringEscapeUtils.unescapeHtml4((String)sline);
                info.setIcon(new URL(sline));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> getQueryMap(String qs) {
        try {
            qs = qs.trim();
            List list = URLEncodedUtils.parse((URI)new URI(null, null, null, -1, null, qs, null), (String)UTF8);
            HashMap<String, String> map = new HashMap<String, String>();
            for (NameValuePair p : list) {
                map.put(p.getName(), p.getValue());
            }
            return map;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(qs, e);
        }
    }

    void extractHtmlInfo(List<VideoDownload> sNextVideoURL, YouTubeInfo info, String html, AtomicBoolean stop, Runnable notify) throws Exception {
        Pattern title;
        Matcher titleMatch;
        String url;
        String itag;
        String sparams;
        Matcher linkMatch;
        Pattern link;
        String urlString;
        int n;
        int n2;
        String[] stringArray;
        String[] urlStrings;
        String sline;
        Pattern encodStream;
        Matcher encodStreamMatch;
        String sline2;
        Matcher encodMatch;
        Pattern encod;
        String url_encoded_fmt_stream_map;
        Pattern urlencod;
        Matcher urlencodMatch;
        Pattern age = Pattern.compile("(verify_age)");
        Matcher ageMatch = age.matcher(html);
        if (ageMatch.find()) {
            throw new AgeException();
        }
        age = Pattern.compile("(unavailable-player)");
        ageMatch = age.matcher(html);
        if (ageMatch.find()) {
            throw new VideoUnavailablePlayer();
        }
        Pattern playerURL = Pattern.compile("(//.*?/player-[\\w\\d\\-]+\\/.*\\.js)");
        Matcher playerVersionMatch = playerURL.matcher(html);
        if (playerVersionMatch.find()) {
            info.setPlayerURI(new URI("https:" + playerVersionMatch.group(1)));
        }
        if ((urlencodMatch = (urlencod = Pattern.compile("\"url_encoded_fmt_stream_map\":\"([^\"]*)\"")).matcher(html)).find()) {
            url_encoded_fmt_stream_map = urlencodMatch.group(1);
            encod = Pattern.compile("url=(.*)");
            encodMatch = encod.matcher(url_encoded_fmt_stream_map);
            if (encodMatch.find()) {
                sline2 = encodMatch.group(1);
                this.extractUrlEncodedVideos(sNextVideoURL, sline2, info, stop, notify);
            }
            if ((encodStreamMatch = (encodStream = Pattern.compile("stream=(.*)")).matcher(url_encoded_fmt_stream_map)).find()) {
                sline = encodStreamMatch.group(1);
                stringArray = urlStrings = sline.split("stream=");
                n2 = urlStrings.length;
                n = 0;
                while (n < n2) {
                    urlString = stringArray[n];
                    urlString = StringEscapeUtils.unescapeJava((String)urlString);
                    link = Pattern.compile("(sparams.*)&itag=(\\d+)&.*&conn=rtmpe(.*),");
                    linkMatch = link.matcher(urlString);
                    if (linkMatch.find()) {
                        sparams = linkMatch.group(1);
                        itag = linkMatch.group(2);
                        url = linkMatch.group(3);
                        url = "https" + url + "?" + sparams;
                        url = URLDecoder.decode(url, UTF8);
                        this.filter(sNextVideoURL, itag, new URL(url));
                    }
                    ++n;
                }
            }
        }
        if ((urlencodMatch = (urlencod = Pattern.compile("\"adaptive_fmts\":\\s*\"([^\"]*)\"")).matcher(html)).find()) {
            url_encoded_fmt_stream_map = urlencodMatch.group(1);
            encod = Pattern.compile("url=(.*)");
            encodMatch = encod.matcher(url_encoded_fmt_stream_map);
            if (encodMatch.find()) {
                sline2 = encodMatch.group(1);
                this.extractUrlEncodedVideos(sNextVideoURL, sline2, info, stop, notify);
            }
            if ((encodStreamMatch = (encodStream = Pattern.compile("stream=(.*)")).matcher(url_encoded_fmt_stream_map)).find()) {
                sline = encodStreamMatch.group(1);
                stringArray = urlStrings = sline.split("stream=");
                n2 = urlStrings.length;
                n = 0;
                while (n < n2) {
                    urlString = stringArray[n];
                    urlString = StringEscapeUtils.unescapeJava((String)urlString);
                    link = Pattern.compile("(sparams.*)&itag=(\\d+)&.*&conn=rtmpe(.*),");
                    linkMatch = link.matcher(urlString);
                    if (linkMatch.find()) {
                        sparams = linkMatch.group(1);
                        itag = linkMatch.group(2);
                        url = linkMatch.group(3);
                        url = "https" + url + "?" + sparams;
                        url = URLDecoder.decode(url, UTF8);
                        this.filter(sNextVideoURL, itag, new URL(url));
                    }
                    ++n;
                }
            }
        }
        if ((titleMatch = (title = Pattern.compile("<meta name=\"title\" content=(.*)")).matcher(html)).find()) {
            String sline3 = titleMatch.group(1);
            String name = sline3.replaceFirst("<meta name=\"title\" content=", "").trim();
            name = StringUtils.strip((String)name, (String)"\">");
            name = StringEscapeUtils.unescapeHtml4((String)name);
            info.setTitle(name);
        }
    }

    void extractUrlEncodedVideos(List<VideoDownload> sNextVideoURL, String sline, YouTubeInfo info, AtomicBoolean stop, Runnable notify) throws Exception {
        String[] urlStrings;
        String[] stringArray = urlStrings = sline.split("url=");
        int n = urlStrings.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern link;
            Matcher linkMatch;
            String sig;
            String urlString = stringArray[n2];
            urlString = StringEscapeUtils.unescapeJava((String)urlString);
            String urlFull = URLDecoder.decode(urlString, UTF8);
            String url = null;
            Pattern link2 = Pattern.compile("([^&,]*)[&,]");
            Matcher linkMatch2 = link2.matcher(urlString);
            if (linkMatch2.find()) {
                url = linkMatch2.group(1);
                url = URLDecoder.decode(url, UTF8);
            }
            String itag = null;
            Pattern link3 = Pattern.compile("itag=(\\d+)");
            Matcher linkMatch3 = link3.matcher(urlFull);
            if (linkMatch3.find()) {
                itag = linkMatch3.group(1);
            }
            if ((sig = null) == null && (linkMatch = (link = Pattern.compile("&signature=([^&,]*)")).matcher(urlFull)).find()) {
                sig = linkMatch.group(1);
            }
            if (sig == null && (linkMatch = (link = Pattern.compile("sig=([^&,]*)")).matcher(urlFull)).find()) {
                sig = linkMatch.group(1);
            }
            if (sig == null && (linkMatch = (link = Pattern.compile("[&,]s=([^&,]*)")).matcher(urlFull)).find()) {
                Object ss;
                sig = linkMatch.group(1);
                if (info.getPlayerURI() == null) {
                    ss = new DecryptSignature(sig);
                    sig = ((DecryptSignature)ss).decrypt();
                } else {
                    ss = new DecryptSignatureHtml5(sig, info.getPlayerURI());
                    sig = ((DecryptSignatureHtml5)ss).decrypt(stop, notify);
                }
            }
            if (url != null && itag != null && sig != null) {
                try {
                    url = String.valueOf(url) + "&signature=" + sig;
                    this.filter(sNextVideoURL, itag, new URL(url));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    @Override
    public List<VideoFileInfo> extract(VideoInfo vinfo, AtomicBoolean stop, Runnable notify) {
        List<VideoDownload> videos = this.extractLinks((YouTubeInfo)vinfo, stop, notify);
        if (videos.size() == 0) {
            throw new DownloadRetry("empty video download list, wait until youtube will process the video");
        }
        ArrayList<VideoDownload> audios = new ArrayList<VideoDownload>();
        int i = videos.size() - 1;
        while (i > 0) {
            if (videos.get((int)i).stream == null) {
                videos.remove(i);
            } else if (videos.get((int)i).stream instanceof YouTubeInfo.StreamAudio) {
                audios.add(videos.remove(i));
            }
            --i;
        }
        Collections.sort(videos, new VideoContentFirst());
        Collections.sort(audios, new VideoContentFirst());
        i = 0;
        if (i < videos.size()) {
            VideoDownload v = videos.get(i);
            YouTubeInfo yinfo = (YouTubeInfo)vinfo;
            yinfo.setStreamInfo(v.stream);
            VideoFileInfo info = new VideoFileInfo(v.url);
            if (v.stream instanceof YouTubeInfo.StreamCombined) {
                vinfo.setInfo(Arrays.asList(info));
            }
            if (v.stream instanceof YouTubeInfo.StreamVideo) {
                if (audios.size() > 0) {
                    VideoFileInfo info2 = new VideoFileInfo(((VideoDownload)audios.get((int)0)).url);
                    vinfo.setInfo(Arrays.asList(info, info2));
                } else {
                    vinfo.setInfo(Arrays.asList(info));
                }
            }
            vinfo.setSource(v.url);
            return vinfo.getInfo();
        }
        throw new DownloadError("no video with required quality found, increace VideoInfo.setVq to the maximum and retry download");
    }

    @Override
    public VideoInfo info(URL web) {
        return new YouTubeInfo(web);
    }

    public static class AgeException
    extends DownloadError {
        private static final long serialVersionUID = 1L;

        public AgeException() {
            super("Age restriction, account required");
        }
    }

    static class DecryptSignature {
        String sig;

        public DecryptSignature(String signature) {
            this.sig = signature;
        }

        String s(int b, int e) {
            return this.sig.substring(b, e);
        }

        String s(int b) {
            return this.sig.substring(b, b + 1);
        }

        String se(int b) {
            return this.s(b, this.sig.length());
        }

        String s(int b, int e, int step) {
            String str = "";
            while (b != e) {
                str = String.valueOf(str) + this.sig.charAt(b);
                b += step;
            }
            return str;
        }

        String decrypt() {
            switch (this.sig.length()) {
                case 93: {
                    return String.valueOf(this.s(86, 29, -1)) + this.s(88) + this.s(28, 5, -1);
                }
                case 92: {
                    return String.valueOf(this.s(25)) + this.s(3, 25) + this.s(0) + this.s(26, 42) + this.s(79) + this.s(43, 79) + this.s(91) + this.s(80, 83);
                }
                case 91: {
                    return String.valueOf(this.s(84, 27, -1)) + this.s(86) + this.s(26, 5, -1);
                }
                case 90: {
                    return String.valueOf(this.s(25)) + this.s(3, 25) + this.s(2) + this.s(26, 40) + this.s(77) + this.s(41, 77) + this.s(89) + this.s(78, 81);
                }
                case 89: {
                    return String.valueOf(this.s(84, 78, -1)) + this.s(87) + this.s(77, 60, -1) + this.s(0) + this.s(59, 3, -1);
                }
                case 88: {
                    return String.valueOf(this.s(7, 28)) + this.s(87) + this.s(29, 45) + this.s(55) + this.s(46, 55) + this.s(2) + this.s(56, 87) + this.s(28);
                }
                case 87: {
                    return String.valueOf(this.s(6, 27)) + this.s(4) + this.s(28, 39) + this.s(27) + this.s(40, 59) + this.s(2) + this.se(60);
                }
                case 86: {
                    return String.valueOf(this.s(80, 72, -1)) + this.s(16) + this.s(71, 39, -1) + this.s(72) + this.s(38, 16, -1) + this.s(82) + this.s(15, 0, -1);
                }
                case 85: {
                    return String.valueOf(this.s(3, 11)) + this.s(0) + this.s(12, 55) + this.s(84) + this.s(56, 84);
                }
                case 84: {
                    return String.valueOf(this.s(78, 70, -1)) + this.s(14) + this.s(69, 37, -1) + this.s(70) + this.s(36, 14, -1) + this.s(80) + this.s(0, 14, -1);
                }
                case 83: {
                    return String.valueOf(this.s(80, 63, -1)) + this.s(0) + this.s(62, 0, -1) + this.s(63);
                }
                case 82: {
                    return String.valueOf(this.s(80, 37, -1)) + this.s(7) + this.s(36, 7, -1) + this.s(0) + this.s(6, 0, -1) + this.s(37);
                }
                case 81: {
                    return String.valueOf(this.s(56)) + this.s(79, 56, -1) + this.s(41) + this.s(55, 41, -1) + this.s(80) + this.s(40, 34, -1) + this.s(0) + this.s(33, 29, -1) + this.s(34) + this.s(28, 9, -1) + this.s(29) + this.s(8, 0, -1) + this.s(9);
                }
                case 80: {
                    return String.valueOf(this.s(1, 19)) + this.s(0) + this.s(20, 68) + this.s(19) + this.s(69, 80);
                }
                case 79: {
                    return String.valueOf(this.s(54)) + this.s(77, 54, -1) + this.s(39) + this.s(53, 39, -1) + this.s(78) + this.s(38, 34, -1) + this.s(0) + this.s(33, 29, -1) + this.s(34) + this.s(28, 9, -1) + this.s(29) + this.s(8, 0, -1) + this.s(9);
                }
            }
            throw new RuntimeException("Unable to decrypt signature, key length " + this.sig.length() + " not supported; retrying might work");
        }
    }

    static class DecryptSignatureHtml5 {
        String sig;
        URI playerURI;
        static ConcurrentMap<String, String> playerCache = new ConcurrentHashMap<String, String>();

        public DecryptSignatureHtml5(String signatur, URI playerURI) {
            this.sig = signatur;
            this.playerURI = playerURI;
        }

        private String getHtml5PlayerScript(AtomicBoolean stop, final Runnable notify) {
            String url = (String)playerCache.get(this.playerURI.toString());
            if (url == null) {
                try {
                    String result = WGet.getHtml((URL)this.playerURI.toURL(), (WGet.HtmlLoader)new WGet.HtmlLoader(){

                        public void notifyRetry(int delay, Throwable e) {
                            notify.run();
                        }

                        public void notifyMoved() {
                            notify.run();
                        }

                        public void notifyDownloading() {
                            notify.run();
                        }
                    }, (AtomicBoolean)stop);
                    playerCache.put(this.playerURI.toString(), result);
                    return result;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            return url;
        }

        private String getMainDecodeFunctionName(String playerJS) {
            Pattern decodeFunctionName = Pattern.compile("\\.sig\\|\\|([a-zA-Z0-9$]+)\\(");
            Matcher decodeFunctionNameMatch = decodeFunctionName.matcher(playerJS);
            if (decodeFunctionNameMatch.find()) {
                return decodeFunctionNameMatch.group(1);
            }
            return null;
        }

        private String extractDecodeFunctions(String playerJS, String functionName) {
            Matcher decodeFunctionHelperMatch;
            StringBuilder decodeScript = new StringBuilder();
            Pattern decodeFunction = Pattern.compile(String.format("(%s=function\\([a-zA-Z0-9$]+\\)\\{.*?\\}),", functionName), 32);
            Matcher decodeFunctionMatch = decodeFunction.matcher(playerJS);
            if (!decodeFunctionMatch.find()) {
                throw new DownloadError("Unable to extract the main decode function!");
            }
            decodeScript.append(decodeFunctionMatch.group(1)).append(';');
            Pattern decodeFunctionHelperName = Pattern.compile("\\);([a-zA-Z0-9]+)\\.");
            Matcher decodeFunctionHelperNameMatch = decodeFunctionHelperName.matcher(decodeScript.toString());
            if (decodeFunctionHelperNameMatch.find()) {
                String decodeFuncHelperName = decodeFunctionHelperNameMatch.group(1);
                Pattern decodeFunctionHelper = Pattern.compile(String.format("(var %s=\\{[a-zA-Z]*:function\\(.*?\\};)", decodeFuncHelperName), 32);
                decodeFunctionHelperMatch = decodeFunctionHelper.matcher(playerJS);
                if (!decodeFunctionHelperMatch.find()) {
                    throw new DownloadError("Unable to extract the helper decode functions!");
                }
            } else {
                throw new DownloadError("Unable to determine the name of the helper decode function!");
            }
            decodeScript.append(decodeFunctionHelperMatch.group(1));
            return decodeScript.toString();
        }

        String decrypt(AtomicBoolean stop, Runnable notify) {
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("JavaScript");
            String playerScript = this.getHtml5PlayerScript(stop, notify);
            String decodeFuncName = this.getMainDecodeFunctionName(playerScript);
            String decodeScript = this.extractDecodeFunctions(playerScript, decodeFuncName);
            String decodedSignature = null;
            try {
                engine.eval(decodeScript);
                Invocable inv = (Invocable)((Object)engine);
                decodedSignature = (String)inv.invokeFunction(decodeFuncName, this.sig);
            }
            catch (Exception e) {
                throw new DownloadError("Unable to decrypt signature!");
            }
            return decodedSignature;
        }
    }

    public static class EmbeddingDisabled
    extends DownloadError {
        private static final long serialVersionUID = 1L;

        public EmbeddingDisabled(String msg) {
            super(msg);
        }
    }

    public static class PrivateVideoException
    extends DownloadError {
        private static final long serialVersionUID = 1L;

        public PrivateVideoException() {
            super("Private video");
        }

        public PrivateVideoException(String s) {
            super(s);
        }
    }

    public static class VideoContentFirst
    implements Comparator<VideoDownload> {
        int ordinal(VideoDownload o1) {
            if (o1.stream instanceof YouTubeInfo.StreamCombined) {
                YouTubeInfo.StreamCombined c1 = (YouTubeInfo.StreamCombined)o1.stream;
                return c1.vq.ordinal();
            }
            if (o1.stream instanceof YouTubeInfo.StreamVideo) {
                YouTubeInfo.StreamVideo c1 = (YouTubeInfo.StreamVideo)o1.stream;
                return c1.vq.ordinal();
            }
            if (o1.stream instanceof YouTubeInfo.StreamAudio) {
                YouTubeInfo.StreamAudio c1 = (YouTubeInfo.StreamAudio)o1.stream;
                return c1.aq.ordinal();
            }
            throw new RuntimeException("bad video array type");
        }

        @Override
        public int compare(VideoDownload o1, VideoDownload o2) {
            Integer i1 = this.ordinal(o1);
            Integer i2 = this.ordinal(o2);
            Integer ic = i1.compareTo(i2);
            return ic;
        }
    }

    public static class VideoDeleted
    extends DownloadError {
        private static final long serialVersionUID = 1L;

        public VideoDeleted(String msg) {
            super(msg);
        }
    }

    public static class VideoDownload {
        public YouTubeInfo.StreamInfo stream;
        public URL url;

        public VideoDownload(YouTubeInfo.StreamInfo s, URL u) {
            this.stream = s;
            this.url = u;
        }
    }

    public static class VideoUnavailablePlayer
    extends DownloadError {
        private static final long serialVersionUID = 10905065542230199L;

        public VideoUnavailablePlayer() {
            super("unavailable-player");
        }
    }
}

