/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.Direct;
import com.github.axet.wget.DirectMultipart;
import com.github.axet.wget.DirectRange;
import com.github.axet.wget.DirectSingle;
import com.github.axet.wget.info.DownloadError;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.DownloadRetry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class WGet {
    private DownloadInfo info;
    Direct d;
    File targetFile;

    public WGet(URL source, File target) {
        this.create(source, target, new AtomicBoolean(false), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public WGet(URL source, File target, AtomicBoolean stop, Runnable notify) {
        this.create(source, target, stop, notify);
    }

    public WGet(DownloadInfo info, File targetFile, AtomicBoolean stop, Runnable notify) {
        this.info = info;
        this.targetFile = targetFile;
        this.create(stop, notify);
    }

    void create(URL source, File target, AtomicBoolean stop, Runnable notify) {
        this.info = new DownloadInfo(source);
        this.info.extract();
        this.create(target, stop, notify);
    }

    void create(File target, AtomicBoolean stop, Runnable notify) {
        this.targetFile = WGet.calcName(this.info, target);
        this.create(stop, notify);
    }

    void create(AtomicBoolean stop, Runnable notify) {
        this.d = this.createDirect(stop, notify);
    }

    Direct createDirect(AtomicBoolean stop, Runnable notify) {
        if (this.info.multipart()) {
            return new DirectMultipart(this.info, this.targetFile, stop, notify);
        }
        if (this.info.range()) {
            return new DirectRange(this.info, this.targetFile, stop, notify);
        }
        return new DirectSingle(this.info, this.targetFile, stop, notify);
    }

    public static File calcName(URL source, File target) {
        DownloadInfo info = new DownloadInfo(source);
        info.extract();
        return WGet.calcName(info, target);
    }

    public static File calcName(DownloadInfo info, File target) {
        String name = null;
        name = info.getContentFilename();
        if (name == null) {
            name = new File(info.getSource().getPath()).getName();
        }
        try {
            name = URLDecoder.decode(name, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String nameNoExt = FilenameUtils.removeExtension((String)name);
        String ext = FilenameUtils.getExtension((String)name);
        File targetFile = null;
        if (target.isDirectory()) {
            targetFile = FileUtils.getFile((File)target, (String[])new String[]{name});
            int i = 1;
            while (targetFile.exists()) {
                targetFile = FileUtils.getFile((File)target, (String[])new String[]{String.valueOf(nameNoExt) + " (" + i + ")." + ext});
                ++i;
            }
        } else {
            try {
                FileUtils.forceMkdir((File)new File(target.getParent()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            targetFile = target;
        }
        return targetFile;
    }

    public void download() {
        this.d.download();
    }

    public DownloadInfo getInfo() {
        return this.info;
    }

    public static String getHtml(URL source) {
        return WGet.getHtml(source, new AtomicBoolean(false));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHtml(URL source, AtomicBoolean stop) {
        try {
            URL u = source;
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
            InputStream is = con.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            StringBuilder contents = new StringBuilder();
            do {
                if ((line = br.readLine()) == null) {
                    return contents.toString();
                }
                contents.append(line);
                contents.append("\n");
            } while (!stop.get());
            return null;
        }
        catch (FileNotFoundException e) {
            throw new DownloadError(e);
        }
        catch (IOException e) {
            throw new DownloadRetry(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

