/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget.info;

import com.github.axet.wget.info.URLInfo;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="DownloadInfo")
public class DownloadInfo
extends URLInfo {
    public static final long PART_LENGTH = 0xA00000L;
    private List<Part> parts;
    private long count;

    public DownloadInfo(URL source) {
        super(source);
    }

    public synchronized boolean multipart() {
        if (!this.range()) {
            return false;
        }
        return this.getParts() != null;
    }

    public synchronized void reset() {
        this.setCount(0L);
        if (this.parts != null) {
            for (Part p : this.parts) {
                p.setCount(0L);
            }
        }
    }

    public synchronized void calculate() {
        this.count = 0L;
        for (Part p : this.getParts()) {
            this.count += p.getCount();
        }
    }

    public synchronized long getCount() {
        return this.count;
    }

    public synchronized void setCount(long count) {
        this.count = count;
    }

    public synchronized List<Part> getParts() {
        return this.parts;
    }

    public synchronized void enableMultipart() {
        if (this.empty()) {
            throw new RuntimeException("Empty Download info, cant set multipart");
        }
        if (!this.range()) {
            throw new RuntimeException("Server does not support RANGE, cant set multipart");
        }
        this.parts = new ArrayList<Part>();
        long count = this.getLength() / 0xA00000L + 1L;
        if (count > 2L) {
            int start = 0;
            int i = 0;
            while ((long)i < count) {
                Part part = new Part();
                part.setNumber(i);
                part.setStart(start);
                part.setEnd(part.getStart() + 0xA00000L - 1L);
                if (part.getEnd() > this.getLength() - 1L) {
                    part.setEnd(this.getLength() - 1L);
                }
                this.parts.add(part);
                start = (int)((long)start + 0xA00000L);
                ++i;
            }
        }
    }

    public synchronized boolean resume(DownloadInfo newSource) {
        if (!newSource.range()) {
            return false;
        }
        if (newSource.getContentFilename() != null && this.getContentFilename() != null ? !newSource.getContentFilename().equals(this.getContentFilename()) : newSource.getContentFilename() != null || this.getContentFilename() != null) {
            return false;
        }
        if (newSource.getLength() != null && this.getLength() != null ? !newSource.getLength().equals(this.getLength()) : newSource.getLength() != null || this.getLength() != null) {
            return false;
        }
        return !(newSource.getContentType() != null && this.getContentType() != null ? !newSource.getContentType().equals(this.getContentType()) : newSource.getContentType() != null || this.getContentType() != null);
    }

    public synchronized void copy(DownloadInfo oldSource) {
        this.count = oldSource.count;
        this.parts = oldSource.parts;
    }

    @XStreamAlias(value="DownloadInfoPart")
    public static class Part {
        private long start;
        private long end;
        private long count;
        private long number;

        public synchronized boolean done() {
            return this.getCount() == this.getLength();
        }

        public synchronized long getStart() {
            return this.start;
        }

        public synchronized void setStart(long start) {
            this.start = start;
        }

        public synchronized long getEnd() {
            return this.end;
        }

        public synchronized void setEnd(long end) {
            this.end = end;
        }

        public synchronized long getLength() {
            return this.end - this.start + 1L;
        }

        public synchronized long getCount() {
            return this.count;
        }

        public synchronized void setCount(long count) {
            this.count = count;
        }

        public long getNumber() {
            return this.number;
        }

        public void setNumber(long number) {
            this.number = number;
        }
    }
}

