/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.Direct;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.DownloadRetry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;

public class DirectSingle
extends Direct {
    public DirectSingle(DownloadInfo info, File target, AtomicBoolean stop, Runnable notify) {
        super(info, target, stop, notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download() {
        try {
            RandomAccessFile fos = null;
            try {
                URL url = this.info.getSource();
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                File f = this.target;
                this.info.setCount(0L);
                f.createNewFile();
                fos = new RandomAccessFile(f, "rw");
                byte[] bytes = new byte[4096];
                int read = 0;
                BufferedInputStream binaryreader = new BufferedInputStream(conn.getInputStream());
                while (!this.stop.get() && (read = binaryreader.read(bytes)) > 0) {
                    this.info.setCount(this.info.getCount() + (long)read);
                    fos.write(bytes, 0, read);
                    this.notify.run();
                }
                binaryreader.close();
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
        catch (IOException e) {
            throw new DownloadRetry(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

