/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import java.util.ArrayList;

public class SpeedInfo {
    ArrayList<Sample> samples = new ArrayList();
    long peak;
    public static final int SAMPLE_LENGTH = 1000;
    public static final int SAMPLE_MAX = 20;
    Sample start = null;

    public void start(long current) {
        Sample s = new Sample(current);
        s.start = true;
        this.start = s;
        this.add(s);
    }

    public void step(long current) {
        long now = System.currentTimeMillis();
        long lastUpdate = this.getLastUpdate();
        if (lastUpdate + 1000L < now) {
            this.add(new Sample(current, now));
        }
    }

    public int getCurrentSpeed() {
        if (this.getRowSamples() < 2) {
            return 0;
        }
        Sample s1 = this.samples.get(this.samples.size() - 2);
        Sample s2 = this.samples.get(this.samples.size() - 1);
        long current = s2.current - s1.current;
        long time = s2.now - s1.now;
        if (time == 0L) {
            return 0;
        }
        return (int)(current * 1000L / time);
    }

    public int getAverageSpeed() {
        if (this.getRowSamples() < 2) {
            return 0;
        }
        Sample s2 = this.samples.get(this.samples.size() - 1);
        long current = s2.current - this.start.current;
        long time = s2.now - this.start.now;
        return (int)(current * 1000L / time);
    }

    public int getSamples() {
        return this.samples.size();
    }

    public Sample getSample(int index) {
        return this.samples.get(index);
    }

    public long getPeak() {
        return this.peak;
    }

    Sample getStart() {
        for (int i = this.samples.size() - 1; i >= 0; --i) {
            Sample s = this.samples.get(i);
            if (!s.start) continue;
            return s;
        }
        return null;
    }

    void add(Sample s) {
        if (this.samples.size() > 0) {
            Sample s1 = this.samples.get(this.samples.size() - 1);
            if (s1.current > s.current) {
                s.start = true;
                this.start = s;
            }
        }
        this.samples.add(s);
        while (this.samples.size() > 20) {
            this.samples.remove(0);
        }
        this.peakUpdate();
    }

    int getRowSamples() {
        for (int i = this.samples.size() - 1; i >= 0; --i) {
            Sample s = this.samples.get(i);
            if (!s.start) continue;
            return this.samples.size() - i;
        }
        return this.samples.size();
    }

    long getLastUpdate() {
        if (this.samples.size() == 0) {
            return 0L;
        }
        Sample s = this.samples.get(this.samples.size() - 1);
        return s.now;
    }

    void peakUpdate() {
        this.peak = 0L;
        for (Sample s : this.samples) {
            if (this.peak >= s.current) continue;
            this.peak = s.current;
        }
    }

    public class Sample {
        public long current;
        public long now;
        public boolean start;

        public Sample() {
            this.current = 0L;
            this.now = System.currentTimeMillis();
            this.start = false;
        }

        public Sample(long current) {
            this.current = current;
            this.now = System.currentTimeMillis();
            this.start = false;
        }

        public Sample(long current, long now) {
            this.current = current;
            this.now = now;
            this.start = false;
        }
    }
}

