/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.Direct;
import com.github.axet.wget.info.DownloadError;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.DownloadMultipartError;
import com.github.axet.wget.info.DownloadRetry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class DirectMultipart
extends Direct {
    public static final int THREAD_COUNT = 3;
    Vector<DownloadInfo.Part> downloads = new Vector();
    LimitDownloader worker = new LimitDownloader();

    public DirectMultipart(DownloadInfo info, File target, AtomicBoolean stop, Runnable notify) {
        super(info, target, stop, notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void part(DownloadInfo.Part part) {
        try {
            RandomAccessFile fos = null;
            try {
                URL url = this.info.getSource();
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                File f = this.target;
                fos = new RandomAccessFile(f, "rw");
                long start = part.getStart() + part.getCount();
                long end = part.getEnd();
                conn.setRequestProperty("Range", "bytes=" + start + "-" + end);
                fos.seek(start);
                byte[] bytes = new byte[4096];
                int read = 0;
                BufferedInputStream binaryreader = new BufferedInputStream(conn.getInputStream());
                boolean localStop = false;
                while (!this.stop.get() && !localStop && (read = binaryreader.read(bytes)) > 0) {
                    long partEnd = part.getLength() - part.getCount();
                    if ((long)read > partEnd) {
                        read = (int)partEnd;
                        localStop = true;
                    }
                    fos.write(bytes, 0, read);
                    part.setCount(part.getCount() + (long)read);
                    this.info.calculate();
                    this.notify.run();
                }
                binaryreader.close();
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
        catch (SocketException e) {
            throw new DownloadRetry(e);
        }
        catch (ProtocolException e) {
            throw new DownloadRetry(e);
        }
        catch (HttpRetryException e) {
            throw new DownloadRetry(e);
        }
        catch (InterruptedIOException e) {
            throw new DownloadRetry(e);
        }
        catch (UnknownHostException e) {
            throw new DownloadRetry(e);
        }
        catch (IOException e) {
            throw new DownloadError(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    DownloadInfo.Part getPart() {
        for (DownloadInfo.Part p : this.info.getParts()) {
            if (p.done() || this.downloads.contains(p)) continue;
            return p;
        }
        return null;
    }

    void download(final DownloadInfo.Part p) {
        this.worker.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DirectMultipart.this.part(p);
                }
                catch (RuntimeException e) {
                    Object object = DirectMultipart.this.worker.lock;
                    synchronized (object) {
                        DirectMultipart.this.worker.t.add(e);
                    }
                }
                finally {
                    DirectMultipart.this.downloads.remove(p);
                }
            }
        });
        this.downloads.add(p);
    }

    boolean done() {
        if (this.stop.get()) {
            return true;
        }
        if (this.worker.active()) {
            return false;
        }
        return this.getPart() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download() {
        try {
            while (!this.done()) {
                DownloadInfo.Part p = this.getPart();
                if (p != null) {
                    this.download(p);
                } else {
                    this.worker.waitUntilNextTaskEnds();
                }
                if (this.worker.errors().isEmpty()) continue;
                while (this.worker.getTasks() > 0) {
                    this.worker.waitUntilNextTaskEnds();
                }
                throw new DownloadMultipartError(this.worker.errors());
            }
        }
        finally {
            this.worker.shutdown();
        }
    }

    static class LimitDownloader
    extends ThreadPoolExecutor {
        Object lock = new Object();
        List<Throwable> t = new LinkedList<Throwable>();

        public LimitDownloader() {
            super(3, 3, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        public boolean active() {
            return this.getTasks() > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUntilNextTaskEnds() {
            Object object = this.lock;
            synchronized (object) {
                if (this.getActiveCount() > 0) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        int getTasks() {
            return this.getActiveCount() + this.getQueue().size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            Object object = this.lock;
            synchronized (object) {
                if (this.getTasks() >= 3) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            super.execute(command);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Throwable> errors() {
            Object object = this.lock;
            synchronized (object) {
                return this.t;
            }
        }
    }
}

