/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget.info;

import com.github.axet.wget.info.DownloadRetry;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLInfo {
    private URL source;
    private boolean extract = false;
    private Long length;
    protected boolean range;
    private String contentType;
    private String contentFilename;

    public URLInfo(URL source) {
        this.source = source;
    }

    public synchronized boolean range() {
        if (this.getLength() == null) {
            return false;
        }
        return this.range;
    }

    public synchronized void extract() {
        Pattern cp;
        Matcher cm;
        HttpURLConnection conn;
        try {
            conn = this.extractRange();
        }
        catch (DownloadRetry e) {
            throw e;
        }
        catch (RuntimeException e) {
            conn = this.extractNormal();
        }
        this.contentType = conn.getContentType();
        String contentDisposition = conn.getHeaderField("Content-Disposition");
        if (contentDisposition != null && (cm = (cp = Pattern.compile("filename=[\"]*([^\"]*)[\"]*")).matcher(contentDisposition)).find()) {
            this.contentFilename = cm.group(1);
        }
        this.extract = true;
    }

    public synchronized boolean empty() {
        return !this.extract;
    }

    protected HttpURLConnection extractRange() {
        try {
            URL url = this.source;
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.setRequestProperty("Range", "bytes=0-0");
            String range = conn.getHeaderField("Content-Range");
            if (range == null) {
                throw new RuntimeException("range not supported");
            }
            Pattern p = Pattern.compile("bytes \\d+-\\d+/(\\d+)");
            Matcher m = p.matcher(range);
            if (!m.find()) {
                throw new RuntimeException("range not supported");
            }
            this.length = new Long(m.group(1));
            this.range = true;
            return conn;
        }
        catch (IOException e) {
            throw new DownloadRetry(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected HttpURLConnection extractNormal() {
        try {
            URL url = this.source;
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            this.range = false;
            int len = conn.getContentLength();
            if (len >= 0) {
                this.length = new Long(len);
            }
            return conn;
        }
        catch (IOException e) {
            throw new DownloadRetry(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized String getContentType() {
        return this.contentType;
    }

    public synchronized Long getLength() {
        return this.length;
    }

    public synchronized URL getSource() {
        return this.source;
    }

    public String getContentFilename() {
        return this.contentFilename;
    }
}

