/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.Direct;
import com.github.axet.wget.info.DownloadError;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.DownloadRetry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;

public class DirectSingle
extends Direct {
    public DirectSingle(DownloadInfo info, File target, AtomicBoolean stop, Runnable notify) {
        super(info, target, stop, notify);
    }

    @Override
    public void download() {
        try {
            RandomAccessFile fos = null;
            try {
                URL url = this.info.getSource();
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                File f = this.target;
                this.info.setCount(0L);
                f.createNewFile();
                fos = new RandomAccessFile(f, "rw");
                byte[] bytes = new byte[4096];
                int read = 0;
                BufferedInputStream binaryreader = new BufferedInputStream(conn.getInputStream());
                while (!this.stop.get() && (read = binaryreader.read(bytes)) > 0) {
                    this.info.setCount(this.info.getCount() + (long)read);
                    fos.write(bytes, 0, read);
                    this.notify.run();
                }
                binaryreader.close();
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
        catch (SocketException e) {
            throw new DownloadRetry(e);
        }
        catch (ProtocolException e) {
            throw new DownloadRetry(e);
        }
        catch (HttpRetryException e) {
            throw new DownloadRetry(e);
        }
        catch (InterruptedIOException e) {
            throw new DownloadRetry(e);
        }
        catch (UnknownHostException e) {
            throw new DownloadRetry(e);
        }
        catch (IOException e) {
            throw new DownloadError(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

