/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.Direct;
import com.github.axet.wget.RetryFactory;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.URLInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;

public class DirectRange
extends Direct {
    public DirectRange(DownloadInfo info, File target) {
        super(info, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(DownloadInfo.Part part, AtomicBoolean stop, Runnable notify) throws IOException {
        RandomAccessFile fos = null;
        BufferedInputStream binaryreader = null;
        try {
            URL url = this.info.getSource();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            File f = this.target;
            if (!f.exists()) {
                f.createNewFile();
            }
            this.info.setCount(FileUtils.sizeOf((File)f));
            if (this.info.getCount() >= this.info.getLength()) {
                notify.run();
                return;
            }
            fos = new RandomAccessFile(f, "rw");
            if (this.info.getCount() > 0L) {
                conn.setRequestProperty("Range", "bytes=" + this.info.getCount() + "-");
                fos.seek(this.info.getCount());
            }
            byte[] bytes = new byte[4096];
            int read = 0;
            binaryreader = new BufferedInputStream(conn.getInputStream());
            while (!stop.get() && (read = binaryreader.read(bytes)) > 0) {
                fos.write(bytes, 0, read);
                part.setCount(part.getCount() + (long)read);
                this.info.calculate();
                notify.run();
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (binaryreader != null) {
                binaryreader.close();
            }
        }
    }

    @Override
    public void download(final AtomicBoolean stop, final Runnable notify) throws InterruptedException {
        this.info.setState(URLInfo.States.DOWNLOADING);
        notify.run();
        List<DownloadInfo.Part> list = this.info.getParts();
        final DownloadInfo.Part p = list.get(0);
        RetryFactory.wrap(stop, new RetryFactory.RetryWrapper(){

            @Override
            public void run() throws IOException {
                DirectRange.this.download(p, stop, notify);
            }

            @Override
            public void notifyRetry(int delay, Throwable e) {
                p.setState(DownloadInfo.Part.States.RETRYING, e);
                DirectRange.this.info.setState(URLInfo.States.RETRYING, e);
                DirectRange.this.info.setDelay(delay);
                p.setDelay(delay);
                notify.run();
            }

            @Override
            public void notifyDownloading() {
                p.setState(DownloadInfo.Part.States.DOWNLOADING);
                DirectRange.this.info.setState(URLInfo.States.DOWNLOADING);
                notify.run();
            }
        });
        p.setState(DownloadInfo.Part.States.DONE);
        this.info.setState(URLInfo.States.DONE);
        notify.run();
    }
}

