/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.Direct;
import com.github.axet.wget.RetryFactory;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.URLInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class DirectSingle
extends Direct {
    public DirectSingle(DownloadInfo info, File target) {
        super(info, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void download(DownloadInfo.Part part, AtomicBoolean stop, Runnable notify) throws IOException {
        RandomAccessFile fos = null;
        try {
            URL url = this.info.getSource();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            File f = this.target;
            this.info.setCount(0L);
            f.createNewFile();
            fos = new RandomAccessFile(f, "rw");
            byte[] bytes = new byte[4096];
            int read = 0;
            BufferedInputStream binaryreader = new BufferedInputStream(conn.getInputStream());
            while (!stop.get() && (read = binaryreader.read(bytes)) > 0) {
                fos.write(bytes, 0, read);
                part.setCount(part.getCount() + (long)read);
                this.info.calculate();
                notify.run();
            }
            binaryreader.close();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    @Override
    public void download(final AtomicBoolean stop, final Runnable notify) throws InterruptedException {
        this.info.setState(URLInfo.States.DOWNLOADING);
        notify.run();
        List<DownloadInfo.Part> list = this.info.getParts();
        final DownloadInfo.Part p = list.get(0);
        RetryFactory.wrap(stop, new RetryFactory.RetryWrapper(){

            @Override
            public void run() throws IOException {
                DirectSingle.this.download(p, stop, notify);
            }

            @Override
            public void notifyRetry(int delay, Throwable e) {
                p.setState(DownloadInfo.Part.States.RETRYING, e);
                p.setDelay(delay);
                DirectSingle.this.info.setState(URLInfo.States.RETRYING, e);
                DirectSingle.this.info.setDelay(delay);
                notify.run();
            }

            @Override
            public void notifyDownloading() {
                p.setState(DownloadInfo.Part.States.DOWNLOADING);
                DirectSingle.this.info.setState(URLInfo.States.DOWNLOADING);
                notify.run();
            }
        });
        p.setState(DownloadInfo.Part.States.DONE);
        this.info.setState(URLInfo.States.DOWNLOADING);
        notify.run();
    }
}

