/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.Direct;
import com.github.axet.wget.LimitThreadPool;
import com.github.axet.wget.RetryFactory;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.URLInfo;
import com.github.axet.wget.info.ex.DownloadMultipartError;
import com.github.axet.wget.info.ex.DownloadRetry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;

public class DirectMultipart
extends Direct {
    public static final int THREAD_COUNT = 3;
    public static final int RETRY_DELAY = 10;
    LimitThreadPool worker = new LimitThreadPool(3);
    boolean fatal = false;
    Object lock = new Object();

    public DirectMultipart(DownloadInfo info, File target) {
        super(info, target);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void download(DownloadInfo.Part part, AtomicBoolean stop, Runnable notify) throws IOException {
        RandomAccessFile fos = null;
        BufferedInputStream binaryreader = null;
        try {
            URL url = this.info.getSource();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            File f = this.target;
            fos = new RandomAccessFile(f, "rw");
            long start = part.getStart() + part.getCount();
            long end = part.getEnd();
            conn.setRequestProperty("Range", "bytes=" + start + "-" + end);
            fos.seek(start);
            byte[] bytes = new byte[4096];
            int read = 0;
            binaryreader = new BufferedInputStream(conn.getInputStream());
            boolean localStop = false;
            while ((read = binaryreader.read(bytes)) > 0) {
                long partEnd = part.getLength() - part.getCount();
                if ((long)read > partEnd) {
                    read = (int)partEnd;
                    localStop = true;
                }
                fos.write(bytes, 0, read);
                part.setCount(part.getCount() + (long)read);
                this.info.calculate();
                notify.run();
                if (stop.get()) {
                    return;
                }
                if (!localStop) continue;
                return;
            }
            if (part.getCount() == part.getLength()) return;
            throw new DownloadRetry("EOF before end of part");
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (binaryreader != null) {
                binaryreader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fatal() {
        Object object = this.lock;
        synchronized (object) {
            return this.fatal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fatal(boolean b) {
        Object object = this.lock;
        synchronized (object) {
            this.fatal = b;
        }
    }

    void downloadWorker(final DownloadInfo.Part p, final AtomicBoolean stop, final Runnable notify) throws InterruptedException {
        this.worker.blockExecute(new Runnable(){

            @Override
            public void run() {
                try {
                    RetryFactory.wrap(stop, new RetryFactory.RetryWrapper(){

                        @Override
                        public void run() throws IOException {
                            DirectMultipart.this.download(p, stop, notify);
                        }

                        @Override
                        public void notifyRetry(int delay, Throwable e) {
                            p.setState(DownloadInfo.Part.States.RETRYING, e);
                            p.setDelay(delay);
                            notify.run();
                        }

                        @Override
                        public void notifyDownloading() {
                            p.setState(DownloadInfo.Part.States.DOWNLOADING);
                            notify.run();
                        }
                    });
                    p.setState(DownloadInfo.Part.States.DONE);
                    notify.run();
                }
                catch (RuntimeException e) {
                    p.setState(DownloadInfo.Part.States.ERROR, e);
                    notify.run();
                    DirectMultipart.this.fatal(true);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        p.setState(DownloadInfo.Part.States.DOWNLOADING);
    }

    DownloadInfo.Part getPart() {
        for (DownloadInfo.Part p : this.info.getParts()) {
            if (!p.getState().equals((Object)DownloadInfo.Part.States.QUEUED)) continue;
            return p;
        }
        return null;
    }

    boolean done(AtomicBoolean stop) throws InterruptedException {
        if (stop.get()) {
            throw new InterruptedException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.worker.active()) {
            return false;
        }
        return this.getPart() == null;
    }

    @Override
    public void download(AtomicBoolean stop, Runnable notify) throws InterruptedException {
        for (DownloadInfo.Part p : this.info.getParts()) {
            p.setState(DownloadInfo.Part.States.QUEUED);
        }
        this.info.setState(URLInfo.States.DOWNLOADING);
        notify.run();
        try {
            while (!this.done(stop)) {
                DownloadInfo.Part p;
                p = this.getPart();
                if (p != null) {
                    this.downloadWorker(p, stop, notify);
                } else {
                    this.worker.waitUntilNextTaskEnds();
                }
                if (!this.fatal()) continue;
                this.worker.waitUntilTermination();
                throw new DownloadMultipartError(this.info);
            }
            this.info.setState(URLInfo.States.DONE);
            notify.run();
        }
        finally {
            this.worker.shutdown();
        }
    }
}

