/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.info.ex.DownloadError;
import com.github.axet.wget.info.ex.DownloadRetry;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpRetryException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;

public class RetryFactory {
    public static final int RETRY_DELAY = 10;

    static <T> void retry(AtomicBoolean stop, RetryWrapperReturn<T> r, RuntimeException e) throws InterruptedException {
        int i = 10;
        while (i > 0) {
            r.notifyRetry(i, e);
            if (stop.get()) {
                throw new InterruptedException("stop");
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("interrrupted");
            }
            Thread.sleep(1000L);
            --i;
        }
    }

    public static <T> T run(AtomicBoolean stop, RetryWrapperReturn<T> r) throws InterruptedException {
        while (true) {
            if (stop.get()) {
                throw new InterruptedException("stop");
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("interrupted");
            }
            try {
                try {
                    r.notifyDownloading();
                    T t = r.run();
                    return t;
                }
                catch (SocketException e) {
                    throw new DownloadRetry(e);
                }
                catch (ProtocolException e) {
                    throw new DownloadRetry(e);
                }
                catch (HttpRetryException e) {
                    throw new DownloadRetry(e);
                }
                catch (InterruptedIOException e) {
                    throw new DownloadRetry(e);
                }
                catch (UnknownHostException e) {
                    throw new DownloadRetry(e);
                }
                catch (IOException e) {
                    throw new DownloadError(e);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (DownloadRetry e) {
                RetryFactory.retry(stop, r, e);
                continue;
            }
            break;
        }
    }

    public static <T> T wrap(AtomicBoolean stop, RetryWrapperReturn<T> r) throws InterruptedException {
        return RetryFactory.run(stop, r);
    }

    public static void wrap(AtomicBoolean stop, final RetryWrapper r) throws InterruptedException {
        RetryWrapperReturn<Object> rr = new RetryWrapperReturn<Object>(){

            @Override
            public Object run() throws IOException {
                r.run();
                return null;
            }

            @Override
            public void notifyRetry(int delay, Throwable e) {
                r.notifyRetry(delay, e);
            }

            @Override
            public void notifyDownloading() {
                r.notifyDownloading();
            }
        };
        RetryFactory.run(stop, rr);
    }

    public static interface RetryWrapper {
        public void notifyRetry(int var1, Throwable var2);

        public void notifyDownloading();

        public void run() throws IOException;
    }

    public static interface RetryWrapperReturn<T> {
        public void notifyRetry(int var1, Throwable var2);

        public void notifyDownloading();

        public T run() throws IOException;
    }
}

