/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.Direct;
import com.github.axet.wget.LimitThreadPool;
import com.github.axet.wget.RetryWrap;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.URLInfo;
import com.github.axet.wget.info.ex.DownloadInterruptedError;
import com.github.axet.wget.info.ex.DownloadMultipartError;
import com.github.axet.wget.info.ex.DownloadRetry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;

public class DirectMultipart
extends Direct {
    public static final int THREAD_COUNT = 3;
    public static final int RETRY_DELAY = 10;
    LimitThreadPool worker = new LimitThreadPool(3);
    boolean fatal = false;
    Object lock = new Object();

    public DirectMultipart(DownloadInfo info, File target) {
        super(info, target);
    }

    void downloadPart(DownloadInfo.Part part, AtomicBoolean stop, Runnable notify) throws IOException {
        RandomAccessFile fos = null;
        BufferedInputStream binaryreader = null;
        try {
            URL url = this.info.getSource();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11");
            File f = this.target;
            fos = new RandomAccessFile(f, "rw");
            long start = part.getStart() + part.getCount();
            long end = part.getEnd();
            conn.setRequestProperty("Range", "bytes=" + start + "-" + end);
            fos.seek(start);
            byte[] bytes = new byte[4096];
            int read = 0;
            binaryreader = new BufferedInputStream(conn.getInputStream());
            boolean localStop = false;
            while ((read = binaryreader.read(bytes)) > 0) {
                long partEnd = part.getLength() - part.getCount();
                if ((long)read > partEnd) {
                    read = (int)partEnd;
                    localStop = true;
                }
                fos.write(bytes, 0, read);
                part.setCount(part.getCount() + (long)read);
                this.info.calculate();
                notify.run();
                if (stop.get()) {
                    throw new DownloadInterruptedError("stop");
                }
                if (Thread.interrupted()) {
                    throw new DownloadInterruptedError("interrupted");
                }
                if (this.fatal()) {
                    throw new DownloadInterruptedError("fatal");
                }
                if (!localStop) continue;
                return;
            }
            if (part.getCount() != part.getLength()) {
                throw new DownloadRetry("EOF before end of part");
            }
        }
        finally {
            if (binaryreader != null) {
                binaryreader.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fatal() {
        Object object = this.lock;
        synchronized (object) {
            return this.fatal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fatal(boolean b) {
        Object object = this.lock;
        synchronized (object) {
            this.fatal = b;
        }
    }

    void downloadWorker(final DownloadInfo.Part p, final AtomicBoolean stop, final Runnable notify) throws InterruptedException {
        this.worker.blockExecute(new Runnable(){

            @Override
            public void run() {
                try {
                    RetryWrap.wrap(stop, new RetryWrap.Wrap(){

                        @Override
                        public void download() throws IOException {
                            p.setState(DownloadInfo.Part.States.DOWNLOADING);
                            notify.run();
                            DirectMultipart.this.downloadPart(p, stop, notify);
                        }

                        @Override
                        public void retry(int delay, Throwable e) {
                            p.setDelay(delay, e);
                            notify.run();
                        }
                    });
                    p.setState(DownloadInfo.Part.States.DONE);
                    notify.run();
                }
                catch (DownloadInterruptedError e) {
                    p.setState(DownloadInfo.Part.States.STOP, e);
                    notify.run();
                    DirectMultipart.this.fatal(true);
                }
                catch (RuntimeException e) {
                    p.setState(DownloadInfo.Part.States.ERROR, e);
                    notify.run();
                    DirectMultipart.this.fatal(true);
                }
            }
        });
        p.setState(DownloadInfo.Part.States.DOWNLOADING);
    }

    DownloadInfo.Part getPart() {
        for (DownloadInfo.Part p : this.info.getParts()) {
            if (!p.getState().equals((Object)DownloadInfo.Part.States.QUEUED)) continue;
            return p;
        }
        return null;
    }

    boolean done(AtomicBoolean stop) {
        if (stop.get()) {
            throw new DownloadInterruptedError("stop");
        }
        if (Thread.interrupted()) {
            throw new DownloadInterruptedError("interupted");
        }
        if (this.worker.active()) {
            return false;
        }
        return this.getPart() == null;
    }

    @Override
    public void download(AtomicBoolean stop, Runnable notify) {
        for (DownloadInfo.Part p : this.info.getParts()) {
            p.setState(DownloadInfo.Part.States.QUEUED);
        }
        this.info.setState(URLInfo.States.DOWNLOADING);
        notify.run();
        try {
            try {
                while (!this.done(stop)) {
                    DownloadInfo.Part p;
                    p = this.getPart();
                    if (p != null) {
                        this.downloadWorker(p, stop, notify);
                    } else {
                        this.worker.waitUntilNextTaskEnds();
                    }
                    if (!this.fatal()) continue;
                    this.worker.waitUntilTermination();
                    boolean interrupted = true;
                    for (DownloadInfo.Part pp : this.info.getParts()) {
                        Throwable e = pp.getException();
                        if (e == null || e instanceof DownloadInterruptedError) continue;
                        interrupted = false;
                    }
                    if (interrupted) {
                        throw new DownloadInterruptedError("multipart all interrupted");
                    }
                    throw new DownloadMultipartError(this.info);
                }
                this.info.setState(URLInfo.States.DONE);
                notify.run();
            }
            catch (InterruptedException e) {
                this.info.setState(URLInfo.States.STOP);
                notify.run();
                throw new DownloadInterruptedError(e);
            }
            catch (RuntimeException e) {
                this.info.setState(URLInfo.States.ERROR);
                notify.run();
                throw e;
            }
        }
        finally {
            this.worker.shutdown();
        }
    }

    public static boolean canResume(DownloadInfo info, File targetFile) {
        if (!targetFile.exists()) {
            return false;
        }
        return targetFile.length() >= info.getCount();
    }
}

