/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class LimitThreadPool
extends ThreadPoolExecutor {
    Object lock = new Object();
    int count = 0;

    public LimitThreadPool(int maxThreadCount) {
        super(0, maxThreadCount, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new BlockUntilFree());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        Object object = this.lock;
        synchronized (object) {
            ++this.count;
            this.lock.notifyAll();
        }
        super.beforeExecute(t, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        Object object = this.lock;
        synchronized (object) {
            --this.count;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean active() {
        Object object = this.lock;
        synchronized (object) {
            return this.count > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilNextTaskEnds() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.active()) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilTermination() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.active()) {
                this.waitUntilNextTaskEnds();
            }
        }
    }

    @Override
    public void execute(Runnable command) {
        SafetyCheck s = (SafetyCheck)command;
        super.execute(s.getCause());
    }

    public void blockExecute(Runnable command) throws InterruptedException {
        this.execute(new SafetyCheck(command));
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    protected static class BlockUntilFree
    implements RejectedExecutionHandler {
        protected BlockUntilFree() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected static class SafetyCheck
    implements Runnable {
        Runnable r;

        public SafetyCheck(Runnable r) {
            this.r = r;
        }

        @Override
        public void run() {
            throw new RuntimeException("should never call run() on this class");
        }

        public Runnable getCause() {
            return this.r;
        }
    }
}

