/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.Direct;
import com.github.axet.wget.DirectMultipart;
import com.github.axet.wget.DirectRange;
import com.github.axet.wget.DirectSingle;
import com.github.axet.wget.RetryWrap;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.ex.DownloadError;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class WGet {
    private DownloadInfo info;
    Direct d;
    File targetFile;

    public WGet(URL source, File target) {
        this.create(source, target);
    }

    public WGet(DownloadInfo info, File targetFile) {
        this.info = info;
        this.targetFile = targetFile;
        this.create();
    }

    void create(URL source, File target) {
        this.info = new DownloadInfo(source);
        this.info.extract();
        this.create(target);
    }

    void create(File target) {
        this.targetFile = WGet.calcName(this.info, target);
        this.create();
    }

    void create() {
        this.d = this.createDirect();
    }

    Direct createDirect() {
        if (this.info.multipart()) {
            return new DirectMultipart(this.info, this.targetFile);
        }
        if (this.info.range()) {
            return new DirectRange(this.info, this.targetFile);
        }
        return new DirectSingle(this.info, this.targetFile);
    }

    public static File calcName(URL source, File target) {
        DownloadInfo info = new DownloadInfo(source);
        info.extract();
        return WGet.calcName(info, target);
    }

    public static File calcName(DownloadInfo info, File target) {
        String name = null;
        name = info.getContentFilename();
        if (name == null) {
            name = new File(info.getSource().getPath()).getName();
        }
        try {
            name = URLDecoder.decode(name, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String nameNoExt = FilenameUtils.removeExtension((String)name);
        String ext = FilenameUtils.getExtension((String)name);
        File targetFile = null;
        if (target.isDirectory()) {
            targetFile = FileUtils.getFile((File)target, (String[])new String[]{name});
            int i = 1;
            while (targetFile.exists()) {
                targetFile = FileUtils.getFile((File)target, (String[])new String[]{nameNoExt + " (" + i + ")." + ext});
                ++i;
            }
        } else {
            try {
                FileUtils.forceMkdir((File)new File(target.getParent()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            targetFile = target;
        }
        return targetFile;
    }

    public void download() {
        this.download(new AtomicBoolean(false), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void download(AtomicBoolean stop, Runnable notify) {
        this.d.download(stop, notify);
    }

    public DownloadInfo getInfo() {
        return this.info;
    }

    public static String getHtml(URL source) {
        try {
            return WGet.getHtml(source, new HtmlLoader(){

                @Override
                public void notifyRetry(int delay, Throwable e) {
                }

                @Override
                public void notifyDownloading() {
                }
            }, new AtomicBoolean(false));
        }
        catch (InterruptedException e) {
            throw new DownloadError(e);
        }
        catch (IOException e) {
            throw new DownloadError(e);
        }
    }

    public static String getHtml(final URL source, final HtmlLoader load, final AtomicBoolean stop) throws InterruptedException, IOException {
        String html = RetryWrap.wrap(stop, new RetryWrap.WrapReturn<String>(){

            @Override
            public void retry(int delay, Throwable e) {
                load.notifyRetry(delay, e);
            }

            @Override
            public String download() throws IOException {
                URL u = source;
                HttpURLConnection con = (HttpURLConnection)u.openConnection();
                con.setConnectTimeout(5000);
                con.setReadTimeout(5000);
                InputStream is = con.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = null;
                StringBuilder contents = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    contents.append(line);
                    contents.append("\n");
                    if (!stop.get()) continue;
                    return null;
                }
                return contents.toString();
            }
        });
        return html;
    }

    public static interface HtmlLoader {
        public void notifyRetry(int var1, Throwable var2);

        public void notifyDownloading();
    }
}

