/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.Direct;
import com.github.axet.wget.RetryWrap;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.URLInfo;
import com.github.axet.wget.info.ex.DownloadInterruptedError;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;

public class DirectSingle
extends Direct {
    public DirectSingle(DownloadInfo info, File target) {
        super(info, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downloadPart(DownloadInfo info, AtomicBoolean stop, Runnable notify) throws IOException {
        RandomAccessFile fos = null;
        try {
            URL url = info.getSource();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            File f = this.target;
            info.setCount(0L);
            f.createNewFile();
            fos = new RandomAccessFile(f, "rw");
            byte[] bytes = new byte[4096];
            int read = 0;
            BufferedInputStream binaryreader = new BufferedInputStream(conn.getInputStream());
            while ((read = binaryreader.read(bytes)) > 0) {
                fos.write(bytes, 0, read);
                info.setCount(info.getCount() + (long)read);
                notify.run();
                if (stop.get()) {
                    throw new DownloadInterruptedError("stop");
                }
                if (!Thread.interrupted()) continue;
                throw new DownloadInterruptedError("interrupted");
            }
            binaryreader.close();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    @Override
    public void download(final AtomicBoolean stop, final Runnable notify) {
        this.info.setState(URLInfo.States.DOWNLOADING);
        notify.run();
        try {
            RetryWrap.wrap(stop, new RetryWrap.Wrap(){

                @Override
                public void download() throws IOException {
                    DirectSingle.this.info.setState(URLInfo.States.DOWNLOADING);
                    notify.run();
                    DirectSingle.this.downloadPart(DirectSingle.this.info, stop, notify);
                }

                @Override
                public void retry(int delay, Throwable e) {
                    DirectSingle.this.info.setDelay(delay, e);
                    notify.run();
                }
            });
            this.info.setState(URLInfo.States.DONE);
            notify.run();
        }
        catch (DownloadInterruptedError e) {
            this.info.setState(URLInfo.States.STOP);
            notify.run();
            throw e;
        }
        catch (RuntimeException e) {
            this.info.setState(URLInfo.States.ERROR);
            notify.run();
            throw e;
        }
    }
}

