/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget.info;

import com.github.axet.wget.RetryWrap;
import com.github.axet.wget.info.ex.DownloadError;
import com.github.axet.wget.info.ex.DownloadRetry;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLInfo {
    private URL source;
    private boolean extract = false;
    private Long length;
    protected boolean range;
    private String contentType;
    private String contentFilename;
    private States state;
    private Throwable exception;
    private int delay;

    public URLInfo(URL source) {
        this.source = source;
    }

    public synchronized boolean range() {
        if (this.getLength() == null) {
            return false;
        }
        return this.range;
    }

    public synchronized void extract() {
        this.extract(new AtomicBoolean(false), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public synchronized void extract(AtomicBoolean stop, final Runnable notify) {
        Pattern cp;
        Matcher cm;
        HttpURLConnection conn = RetryWrap.wrap(stop, new RetryWrap.WrapReturn<HttpURLConnection>(){

            @Override
            public HttpURLConnection download() throws IOException {
                URLInfo.this.setState(States.EXTRACTING);
                notify.run();
                try {
                    return URLInfo.this.extractRange();
                }
                catch (DownloadRetry e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    return URLInfo.this.extractNormal();
                }
            }

            @Override
            public void retry(int d, Throwable ee) {
                URLInfo.this.setDelay(d, ee);
                notify.run();
            }
        });
        this.contentType = conn.getContentType();
        String contentDisposition = conn.getHeaderField("Content-Disposition");
        if (contentDisposition != null && (cm = (cp = Pattern.compile("filename=[\"]*([^\"]*)[\"]*")).matcher(contentDisposition)).find()) {
            this.contentFilename = cm.group(1);
        }
        this.extract = true;
        this.setState(States.EXTRACTING_DONE);
        notify.run();
    }

    public synchronized boolean empty() {
        return !this.extract;
    }

    protected HttpURLConnection extractRange() throws IOException {
        URL url = this.source;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        conn.setRequestProperty("Range", "bytes=0-0");
        int code = conn.getResponseCode();
        switch (code) {
            case 200: 
            case 206: {
                break;
            }
            default: {
                throw new DownloadError(conn.getResponseMessage());
            }
        }
        String range = conn.getHeaderField("Content-Range");
        if (range == null) {
            throw new RuntimeException("range not supported");
        }
        Pattern p = Pattern.compile("bytes \\d+-\\d+/(\\d+)");
        Matcher m = p.matcher(range);
        if (!m.find()) {
            throw new RuntimeException("range not supported");
        }
        this.length = new Long(m.group(1));
        this.range = true;
        return conn;
    }

    protected HttpURLConnection extractNormal() throws IOException {
        URL url = this.source;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        this.range = false;
        int code = conn.getResponseCode();
        switch (code) {
            case 200: 
            case 206: {
                break;
            }
            default: {
                throw new DownloadError(conn.getResponseMessage());
            }
        }
        int len = conn.getContentLength();
        if (len >= 0) {
            this.length = new Long(len);
        }
        return conn;
    }

    public synchronized String getContentType() {
        return this.contentType;
    }

    public synchronized Long getLength() {
        return this.length;
    }

    public synchronized URL getSource() {
        return this.source;
    }

    public synchronized String getContentFilename() {
        return this.contentFilename;
    }

    public synchronized States getState() {
        return this.state;
    }

    public synchronized void setState(States state) {
        this.state = state;
        this.exception = null;
    }

    public synchronized void setState(States state, Throwable e) {
        this.state = state;
        this.exception = e;
    }

    public synchronized Throwable getException() {
        return this.exception;
    }

    protected synchronized void setException(Throwable exception) {
        this.exception = exception;
    }

    public synchronized int getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(int delay, Throwable e) {
        this.delay = delay;
        this.exception = e;
        this.state = States.RETRYING;
    }

    public static enum States {
        EXTRACTING,
        EXTRACTING_DONE,
        DOWNLOADING,
        RETRYING,
        STOP,
        ERROR,
        DONE;

    }
}

