/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.info.ex.DownloadError;
import com.github.axet.wget.info.ex.DownloadIOError;
import com.github.axet.wget.info.ex.DownloadInterruptedError;
import com.github.axet.wget.info.ex.DownloadMoved;
import com.github.axet.wget.info.ex.DownloadRetry;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpRetryException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;

public class RetryWrap {
    public static final int RETRY_DELAY = 10;

    static <T> void moved(AtomicBoolean stop, WrapReturn<T> r, DownloadMoved e) {
        if (stop.get()) {
            throw new DownloadInterruptedError("stop");
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new DownloadInterruptedError("interrrupted");
        }
        r.moved(e.getMoved());
    }

    static <T> void retry(AtomicBoolean stop, WrapReturn<T> r, RuntimeException e) {
        int i = 10;
        while (i >= 0) {
            r.retry(i, e);
            if (stop.get()) {
                throw new DownloadInterruptedError("stop");
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new DownloadInterruptedError("interrrupted");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                throw new DownloadInterruptedError(e1);
            }
            --i;
        }
    }

    public static <T> T run(AtomicBoolean stop, WrapReturn<T> r) {
        while (true) {
            if (stop.get()) {
                throw new DownloadInterruptedError("stop");
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new DownloadInterruptedError("interrupted");
            }
            try {
                try {
                    T t = r.download();
                    return t;
                }
                catch (SocketException e) {
                    throw new DownloadRetry(e);
                }
                catch (ProtocolException e) {
                    throw new DownloadRetry(e);
                }
                catch (HttpRetryException e) {
                    throw new DownloadRetry(e);
                }
                catch (InterruptedIOException e) {
                    throw new DownloadRetry(e);
                }
                catch (UnknownHostException e) {
                    throw new DownloadRetry(e);
                }
                catch (FileNotFoundException e) {
                    throw new DownloadError(e);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new DownloadIOError(e);
                }
            }
            catch (DownloadMoved e) {
                RetryWrap.moved(stop, r, e);
                continue;
            }
            catch (DownloadRetry e) {
                RetryWrap.retry(stop, r, e);
                continue;
            }
            break;
        }
    }

    public static <T> T wrap(AtomicBoolean stop, WrapReturn<T> r) {
        return RetryWrap.run(stop, r);
    }

    public static void wrap(AtomicBoolean stop, final Wrap r) {
        WrapReturn<Object> rr = new WrapReturn<Object>(){

            @Override
            public Object download() throws IOException {
                r.download();
                return null;
            }

            @Override
            public void retry(int delay, Throwable e) {
                r.retry(delay, e);
            }

            @Override
            public void moved(URL url) {
                r.moved(url);
            }
        };
        RetryWrap.run(stop, rr);
    }

    public static interface Wrap {
        public void retry(int var1, Throwable var2);

        public void moved(URL var1);

        public void download() throws IOException;
    }

    public static interface WrapReturn<T> {
        public void retry(int var1, Throwable var2);

        public void moved(URL var1);

        public T download() throws IOException;
    }
}

