/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget.info;

import com.github.axet.wget.RetryWrap;
import com.github.axet.wget.info.ex.DownloadRetry;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLInfo {
    private URL source;
    private boolean extract = false;
    private Long length;
    private boolean range;
    private String contentType;
    private String contentFilename;
    private States state;
    private Throwable exception;
    private int delay;

    public URLInfo(URL source) {
        this.source = source;
    }

    public synchronized void extract() {
        this.extract(new AtomicBoolean(false), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public synchronized void extract(AtomicBoolean stop, final Runnable notify) {
        try {
            Pattern cp;
            Matcher cm;
            HttpURLConnection conn = RetryWrap.wrap(stop, new RetryWrap.WrapReturn<HttpURLConnection>(){

                @Override
                public HttpURLConnection download() throws IOException {
                    URLInfo.this.setState(States.EXTRACTING);
                    notify.run();
                    try {
                        return URLInfo.this.extractRange();
                    }
                    catch (DownloadRetry e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        return URLInfo.this.extractNormal();
                    }
                }

                @Override
                public void retry(int d, Throwable ee) {
                    URLInfo.this.setDelay(d, ee);
                    notify.run();
                }

                @Override
                public void moved(URL url) {
                    URLInfo.this.setState(States.RETRYING);
                    notify.run();
                }
            });
            this.contentType = conn.getContentType();
            String contentDisposition = conn.getHeaderField("Content-Disposition");
            if (contentDisposition != null && (cm = (cp = Pattern.compile("filename=[\"]*([^\"]*)[\"]*")).matcher(contentDisposition)).find()) {
                this.contentFilename = cm.group(1);
            }
            this.extract = true;
            this.setState(States.EXTRACTING_DONE);
            notify.run();
        }
        catch (RuntimeException e) {
            this.setState(States.ERROR, e);
            throw e;
        }
    }

    public synchronized boolean empty() {
        return !this.extract;
    }

    protected HttpURLConnection extractRange() throws IOException {
        URL url = this.source;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11");
        conn.setRequestProperty("Range", "bytes=0-0");
        RetryWrap.check(conn);
        String range = conn.getHeaderField("Content-Range");
        if (range == null) {
            throw new RuntimeException("range not supported");
        }
        Pattern p = Pattern.compile("bytes \\d+-\\d+/(\\d+)");
        Matcher m = p.matcher(range);
        if (!m.find()) {
            throw new RuntimeException("range not supported");
        }
        this.length = new Long(m.group(1));
        this.setRange(true);
        return conn;
    }

    protected HttpURLConnection extractNormal() throws IOException {
        URL url = this.source;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11");
        this.setRange(false);
        RetryWrap.check(conn);
        int len = conn.getContentLength();
        if (len >= 0) {
            this.length = new Long(len);
        }
        return conn;
    }

    public synchronized String getContentType() {
        return this.contentType;
    }

    public synchronized Long getLength() {
        return this.length;
    }

    public synchronized URL getSource() {
        return this.source;
    }

    public synchronized String getContentFilename() {
        return this.contentFilename;
    }

    public synchronized States getState() {
        return this.state;
    }

    public synchronized void setState(States state) {
        this.state = state;
        this.exception = null;
        this.delay = 0;
    }

    public synchronized void setState(States state, Throwable e) {
        this.state = state;
        this.exception = e;
        this.delay = 0;
    }

    public synchronized Throwable getException() {
        return this.exception;
    }

    protected synchronized void setException(Throwable exception) {
        this.exception = exception;
    }

    public synchronized int getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(int delay, Throwable e) {
        this.delay = delay;
        this.exception = e;
        this.state = States.RETRYING;
    }

    public boolean getRange() {
        return this.range;
    }

    public void setRange(boolean range) {
        this.range = range;
    }

    public static enum States {
        EXTRACTING,
        EXTRACTING_DONE,
        DOWNLOADING,
        RETRYING,
        STOP,
        ERROR,
        DONE;

    }
}

