/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.info.ex.DownloadError;
import com.github.axet.wget.info.ex.DownloadIOCodeError;
import com.github.axet.wget.info.ex.DownloadIOError;
import com.github.axet.wget.info.ex.DownloadInterruptedError;
import com.github.axet.wget.info.ex.DownloadMoved;
import com.github.axet.wget.info.ex.DownloadRetry;
import com.github.axet.wget.info.ex.ProxyAuth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;

public class RetryWrap {
    public static int RETRY_DELAY = 10;
    public static int RETRY_SLEEP = 1000;

    static <T> void moved(AtomicBoolean stop, WrapReturn<T> r, DownloadMoved e) {
        if (stop.get()) {
            throw new DownloadInterruptedError("stop");
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new DownloadInterruptedError("interrrupted");
        }
        r.moved(e.getMoved());
    }

    static <T> void retry(AtomicBoolean stop, WrapReturn<T> r, RuntimeException e) {
        int i = RETRY_DELAY;
        while (i >= 0) {
            r.retry(i, e);
            if (stop.get()) {
                throw new DownloadInterruptedError("stop");
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new DownloadInterruptedError("interrrupted");
            }
            try {
                Thread.sleep(RETRY_SLEEP);
            }
            catch (InterruptedException e1) {
                throw new DownloadInterruptedError(e1);
            }
            --i;
        }
    }

    public static <T> T run(AtomicBoolean stop, WrapReturn<T> r) {
        while (true) {
            if (stop.get()) {
                throw new DownloadInterruptedError("stop");
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new DownloadInterruptedError("interrupted");
            }
            try {
                try {
                    try {
                        T t = r.download();
                        return t;
                    }
                    catch (ProxyAuth e) {
                        try {
                            r.proxy();
                            T t = r.download();
                            return t;
                        }
                        catch (ProxyAuth e2) {
                            throw new DownloadError(e2);
                        }
                    }
                }
                catch (SocketException e) {
                    throw new DownloadRetry(e);
                }
                catch (ProtocolException e) {
                    throw new DownloadRetry(e);
                }
                catch (HttpRetryException e) {
                    throw new DownloadRetry(e);
                }
                catch (InterruptedIOException e) {
                    throw new DownloadRetry(e);
                }
                catch (UnknownHostException e) {
                    throw new DownloadRetry(e);
                }
                catch (FileNotFoundException e) {
                    throw new DownloadError(e);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new DownloadIOError(e);
                }
            }
            catch (DownloadMoved e) {
                RetryWrap.moved(stop, r, e);
                continue;
            }
            catch (DownloadRetry e) {
                RetryWrap.retry(stop, r, e);
                continue;
            }
            break;
        }
    }

    public static <T> T wrap(AtomicBoolean stop, WrapReturn<T> r) {
        return RetryWrap.run(stop, r);
    }

    public static void wrap(AtomicBoolean stop, final Wrap r) {
        WrapReturn<Object> rr = new WrapReturn<Object>(){

            @Override
            public Object download() throws IOException {
                r.download();
                return null;
            }

            @Override
            public void retry(int delay, Throwable e) {
                r.retry(delay, e);
            }

            @Override
            public void moved(URL url) {
                r.moved(url);
            }

            @Override
            public void proxy() {
                r.proxy();
            }
        };
        RetryWrap.run(stop, rr);
    }

    public static void check(HttpURLConnection c) throws IOException {
        int code = c.getResponseCode();
        switch (code) {
            case 200: 
            case 206: {
                return;
            }
            case 301: 
            case 302: {
                throw new DownloadMoved(c);
            }
            case 407: {
                throw new ProxyAuth(c);
            }
            case 403: {
                throw new DownloadIOCodeError(403);
            }
            case 416: {
                throw new DownloadIOCodeError(416);
            }
        }
    }

    public static interface Wrap {
        public void proxy();

        public void retry(int var1, Throwable var2);

        public void moved(URL var1);

        public void download() throws IOException;
    }

    public static interface WrapReturn<T> {
        public void proxy();

        public void retry(int var1, Throwable var2);

        public void moved(URL var1);

        public T download() throws IOException;
    }
}

