/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.Direct;
import com.github.axet.wget.RetryWrap;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.URLInfo;
import com.github.axet.wget.info.ex.DownloadInterruptedError;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;

public class DirectRange
extends Direct {
    public DirectRange(DownloadInfo info, File target) {
        super(info, target);
    }

    public void downloadPart(DownloadInfo info, AtomicBoolean stop, Runnable notify) throws IOException {
        RandomAccessFile fos = null;
        BufferedInputStream binaryreader = null;
        try {
            URL url = info.getSource();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11");
            File f = this.target;
            if (!f.exists()) {
                f.createNewFile();
            }
            info.setCount(FileUtils.sizeOf((File)f));
            if (info.getCount() >= info.getLength()) {
                notify.run();
                return;
            }
            fos = new RandomAccessFile(f, "rw");
            if (info.getCount() > 0L) {
                conn.setRequestProperty("Range", "bytes=" + info.getCount() + "-");
                fos.seek(info.getCount());
            }
            byte[] bytes = new byte[4096];
            int read = 0;
            RetryWrap.check(conn);
            binaryreader = new BufferedInputStream(conn.getInputStream());
            while ((read = binaryreader.read(bytes)) > 0) {
                fos.write(bytes, 0, read);
                info.setCount(info.getCount() + (long)read);
                notify.run();
                if (stop.get()) {
                    throw new DownloadInterruptedError("stop");
                }
                if (!Thread.interrupted()) continue;
                throw new DownloadInterruptedError("interrupted");
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (binaryreader != null) {
                binaryreader.close();
            }
        }
    }

    @Override
    public void download(final AtomicBoolean stop, final Runnable notify) {
        this.info.setState(URLInfo.States.DOWNLOADING);
        notify.run();
        try {
            RetryWrap.wrap(stop, new RetryWrap.Wrap(){

                @Override
                public void download() throws IOException {
                    DirectRange.this.info.setState(URLInfo.States.DOWNLOADING);
                    notify.run();
                    DirectRange.this.downloadPart(DirectRange.this.info, stop, notify);
                }

                @Override
                public void retry(int delay, Throwable e) {
                    DirectRange.this.info.setDelay(delay, e);
                    notify.run();
                }

                @Override
                public void moved(URL url) {
                    DirectRange.this.info.setState(URLInfo.States.RETRYING);
                    notify.run();
                }
            });
            this.info.setState(URLInfo.States.DONE);
            notify.run();
        }
        catch (DownloadInterruptedError e) {
            this.info.setState(URLInfo.States.STOP);
            notify.run();
            throw e;
        }
        catch (RuntimeException e) {
            this.info.setState(URLInfo.States.ERROR);
            notify.run();
            throw e;
        }
    }

    public static boolean canResume(DownloadInfo info, File targetFile) {
        return !(targetFile.exists() ? info.getCount() != targetFile.length() : info.getCount() > 0L);
    }
}

