/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget.info;

import com.github.axet.wget.RetryWrap;
import com.github.axet.wget.info.ex.DownloadRetry;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLInfo {
    private URL source;
    private boolean extract = false;
    private Long length;
    private boolean range;
    private String contentType;
    private String contentFilename;
    private States state;
    private Throwable exception;
    private int delay;

    public URLInfo(URL source) {
        this.source = source;
    }

    public void extract() {
        this.extract(new AtomicBoolean(false), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void extract(AtomicBoolean stop, final Runnable notify) {
        try {
            Pattern cp;
            Matcher cm;
            HttpURLConnection conn = RetryWrap.wrap(stop, new RetryWrap.WrapReturn<HttpURLConnection>(){
                URL url;
                {
                    this.url = URLInfo.this.source;
                }

                @Override
                public HttpURLConnection download() throws IOException {
                    URLInfo.this.setState(States.EXTRACTING);
                    notify.run();
                    try {
                        return URLInfo.this.extractRange(this.url);
                    }
                    catch (DownloadRetry e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        return URLInfo.this.extractNormal(this.url);
                    }
                }

                @Override
                public void retry(int d, Throwable ee) {
                    URLInfo.this.setDelay(d, ee);
                    notify.run();
                }

                @Override
                public void moved(URL u) {
                    this.url = u;
                    URLInfo.this.setState(States.RETRYING);
                    notify.run();
                }
            });
            this.setContentType(conn.getContentType());
            String contentDisposition = conn.getHeaderField("Content-Disposition");
            if (contentDisposition != null && (cm = (cp = Pattern.compile("filename=[\"]*([^\"]*)[\"]*")).matcher(contentDisposition)).find()) {
                this.setContentFilename(cm.group(1));
            }
            this.setEmpty(true);
            this.setState(States.EXTRACTING_DONE);
            notify.run();
        }
        catch (RuntimeException e) {
            this.setState(States.ERROR, e);
            throw e;
        }
    }

    public synchronized boolean empty() {
        return !this.extract;
    }

    public synchronized void setEmpty(boolean b) {
        this.extract = b;
    }

    protected HttpURLConnection extractRange(URL source) throws IOException {
        URL url = source;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11");
        conn.setRequestProperty("Range", "bytes=0-0");
        RetryWrap.check(conn);
        String range = conn.getHeaderField("Content-Range");
        if (range == null) {
            throw new RuntimeException("range not supported");
        }
        Pattern p = Pattern.compile("bytes \\d+-\\d+/(\\d+)");
        Matcher m = p.matcher(range);
        if (!m.find()) {
            throw new RuntimeException("range not supported");
        }
        this.setLength(new Long(m.group(1)));
        this.setRange(true);
        return conn;
    }

    protected HttpURLConnection extractNormal(URL source) throws IOException {
        URL url = source;
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_2) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.64 Safari/537.11");
        this.setRange(false);
        RetryWrap.check(conn);
        int len = conn.getContentLength();
        if (len >= 0) {
            this.setLength(new Long(len));
        }
        return conn;
    }

    public synchronized String getContentType() {
        return this.contentType;
    }

    public synchronized void setContentType(String ct) {
        this.contentType = ct;
    }

    public synchronized Long getLength() {
        return this.length;
    }

    public synchronized void setLength(Long l) {
        this.length = l;
    }

    public synchronized URL getSource() {
        return this.source;
    }

    public synchronized String getContentFilename() {
        return this.contentFilename;
    }

    public synchronized void setContentFilename(String f) {
        this.contentFilename = f;
    }

    public synchronized States getState() {
        return this.state;
    }

    public synchronized void setState(States state) {
        this.state = state;
        this.exception = null;
        this.delay = 0;
    }

    public synchronized void setState(States state, Throwable e) {
        this.state = state;
        this.exception = e;
        this.delay = 0;
    }

    public synchronized Throwable getException() {
        return this.exception;
    }

    protected synchronized void setException(Throwable exception) {
        this.exception = exception;
    }

    public synchronized int getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(int delay, Throwable e) {
        this.delay = delay;
        this.exception = e;
        this.state = States.RETRYING;
    }

    public synchronized boolean getRange() {
        return this.range;
    }

    public synchronized void setRange(boolean range) {
        this.range = range;
    }

    public static enum States {
        EXTRACTING,
        EXTRACTING_DONE,
        DOWNLOADING,
        RETRYING,
        STOP,
        ERROR,
        DONE;

    }
}

