/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.Direct;
import com.github.axet.wget.DirectMultipart;
import com.github.axet.wget.DirectRange;
import com.github.axet.wget.DirectSingle;
import com.github.axet.wget.RetryWrap;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.ex.DownloadInterruptedError;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class WGet {
    public static final String UTF8 = "UTF-8";
    private DownloadInfo info;
    Direct d;
    File targetFile;

    public WGet(URL source, File target) {
        this.create(source, target);
    }

    public WGet(DownloadInfo info, File targetFile) {
        this.info = info;
        this.targetFile = targetFile;
        this.create();
    }

    void create(URL source, File target) {
        this.info = new DownloadInfo(source);
        this.info.extract();
        this.create(target);
    }

    void create(File target) {
        this.targetFile = WGet.calcName(this.info, target);
        this.create();
    }

    void create() {
        this.d = this.createDirect();
    }

    Direct createDirect() {
        if (this.info.multipart()) {
            return new DirectMultipart(this.info, this.targetFile){

                @Override
                protected void moved(DownloadInfo.Part p, URL url, Runnable notify) {
                    DownloadInfo old = this.info;
                    this.info = new DownloadInfo(url);
                    if (old.resume(this.info)) {
                        this.info.copy(old);
                    } else {
                        FileUtils.deleteQuietly((File)WGet.this.targetFile);
                    }
                    if (!this.info.getRange()) {
                        WGet.this.create();
                        this.fatal(true);
                    }
                    super.moved(p, url, notify);
                }
            };
        }
        if (this.info.getRange()) {
            return new DirectRange(this.info, this.targetFile){

                @Override
                protected void moved(URL url, Runnable notify) {
                    DownloadInfo old = this.info;
                    this.info = new DownloadInfo(url);
                    if (old.resume(this.info)) {
                        this.info.copy(old);
                    } else {
                        FileUtils.deleteQuietly((File)WGet.this.targetFile);
                    }
                    super.moved(url, notify);
                }
            };
        }
        return new DirectSingle(this.info, this.targetFile){

            @Override
            protected void moved(URL url, Runnable notify) {
                if (WGet.this.targetFile.exists()) {
                    WGet.this.targetFile.delete();
                }
                DownloadInfo old = this.info;
                this.info = new DownloadInfo(url);
                this.info.setReferer(old.getReferer());
                super.moved(url, notify);
            }
        };
    }

    public static File calcName(URL source, File target) {
        DownloadInfo info = new DownloadInfo(source);
        info.extract();
        return WGet.calcName(info, target);
    }

    public static File calcName(DownloadInfo info, File target) {
        String name = null;
        name = info.getContentFilename();
        if (name == null) {
            name = new File(info.getSource().getPath()).getName();
        }
        try {
            name = URLDecoder.decode(name, UTF8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String nameNoExt = FilenameUtils.removeExtension((String)name);
        String ext = FilenameUtils.getExtension((String)name);
        File targetFile = null;
        if (target.isDirectory()) {
            targetFile = FileUtils.getFile((File)target, (String[])new String[]{name});
            int i = 1;
            while (targetFile.exists()) {
                targetFile = FileUtils.getFile((File)target, (String[])new String[]{nameNoExt + " (" + i + ")." + ext});
                ++i;
            }
        } else {
            try {
                FileUtils.forceMkdir((File)new File(target.getParent()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            targetFile = target;
        }
        return targetFile;
    }

    public void download() {
        this.download(new AtomicBoolean(false), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void download(AtomicBoolean stop, Runnable notify) {
        this.d.download(stop, notify);
    }

    public DownloadInfo getInfo() {
        return this.info;
    }

    public static String getHtml(URL source) {
        return WGet.getHtml(source, new HtmlLoader(){

            @Override
            public void notifyRetry(int retry, int delay, Throwable e) {
            }

            @Override
            public void notifyDownloading() {
            }

            @Override
            public void notifyMoved() {
            }
        }, new AtomicBoolean(false));
    }

    public static String getHtml(DownloadInfo info) {
        return WGet.getHtml(info, new HtmlLoader(){

            @Override
            public void notifyRetry(int retry, int delay, Throwable e) {
            }

            @Override
            public void notifyDownloading() {
            }

            @Override
            public void notifyMoved() {
            }
        }, new AtomicBoolean(false));
    }

    public static String getHtml(URL source, HtmlLoader load, AtomicBoolean stop) {
        return WGet.getHtml(new DownloadInfo(source), load, stop);
    }

    public static String getHtml(final DownloadInfo source, final HtmlLoader load, final AtomicBoolean stop) {
        String html = RetryWrap.wrap(stop, new RetryWrap.WrapReturn<String>(){
            DownloadInfo info;
            {
                this.info = source;
            }

            @Override
            public void proxy() {
                this.info.getProxy().set();
            }

            @Override
            public void resume() {
                this.info.setRetry(0);
            }

            @Override
            public void error(Throwable e) {
                this.info.setRetry(this.info.getRetry() + 1);
            }

            @Override
            public boolean retry(int delay, Throwable e) {
                load.notifyRetry(this.info.getRetry(), delay, e);
                return RetryWrap.retry(this.info.getRetry());
            }

            @Override
            public String download() throws IOException {
                HttpURLConnection conn = this.info.openConnection();
                RetryWrap.check(conn);
                return WGet.getHtml(conn, stop);
            }

            @Override
            public void moved(URL url) {
                DownloadInfo old = this.info;
                this.info = new DownloadInfo(url);
                this.info.setReferer(old.getReferer());
                load.notifyMoved();
            }
        });
        return html;
    }

    public static String getHtml(HttpURLConnection conn, AtomicBoolean stop) throws IOException {
        Pattern p;
        Matcher m;
        InputStream is = conn.getInputStream();
        String enc = conn.getContentEncoding();
        if (enc == null && (m = (p = Pattern.compile("charset=(.*)")).matcher(conn.getHeaderField("Content-Type"))).find()) {
            enc = m.group(1);
        }
        if (enc == null) {
            enc = UTF8;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, enc));
        String line = null;
        StringBuilder contents = new StringBuilder();
        while ((line = br.readLine()) != null) {
            contents.append(line);
            contents.append("\n");
            if (stop.get()) {
                throw new DownloadInterruptedError("stop");
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new DownloadInterruptedError("interrupted");
        }
        return contents.toString();
    }

    public static interface HtmlLoader {
        public void notifyRetry(int var1, int var2, Throwable var3);

        public void notifyDownloading();

        public void notifyMoved();
    }
}

