/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.threads.LimitThreadPool;
import com.github.axet.wget.Direct;
import com.github.axet.wget.RetryWrap;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.URLInfo;
import com.github.axet.wget.info.ex.DownloadInterruptedError;
import com.github.axet.wget.info.ex.DownloadMultipartError;
import com.github.axet.wget.info.ex.DownloadRetry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class DirectMultipart
extends Direct {
    public static int THREAD_COUNT = 3;
    List<DownloadInfo.Part> active = Collections.synchronizedList(new ArrayList());
    LimitThreadPool worker = new LimitThreadPool(THREAD_COUNT);
    boolean fatal = false;
    Object lock = new Object();

    public DirectMultipart(DownloadInfo info, File target) {
        super(info, target);
    }

    void downloadPart(RetryWrap.Wrap w, DownloadInfo.Part part, AtomicBoolean stop, Runnable notify) throws IOException {
        RandomAccessFile fos = null;
        BufferedInputStream binaryreader = null;
        try {
            long start = part.getStart() + part.getCount();
            long end = part.getEnd();
            if (end - start + 1L == 0L) {
                return;
            }
            HttpURLConnection conn = this.info.openConnection();
            File f = this.target;
            fos = new RandomAccessFile(f, "rw");
            conn.setRequestProperty("Range", "bytes=" + start + "-" + end);
            fos.seek(start);
            byte[] bytes = new byte[BUF_SIZE];
            int read = 0;
            RetryWrap.check(conn);
            binaryreader = new BufferedInputStream(conn.getInputStream());
            boolean localStop = false;
            while ((read = binaryreader.read(bytes)) > 0) {
                w.resume();
                long partEnd = part.getLength() - part.getCount();
                if ((long)read > partEnd) {
                    read = (int)partEnd;
                    localStop = true;
                }
                fos.write(bytes, 0, read);
                part.setCount(part.getCount() + (long)read);
                this.info.calculate();
                notify.run();
                if (stop.get()) {
                    throw new DownloadInterruptedError("stop");
                }
                if (Thread.interrupted()) {
                    throw new DownloadInterruptedError("interrupted");
                }
                if (this.fatal()) {
                    throw new DownloadInterruptedError("fatal");
                }
                if (!localStop) continue;
                return;
            }
            if (part.getCount() != part.getLength()) {
                throw new DownloadRetry("EOF before end of part");
            }
        }
        finally {
            if (binaryreader != null) {
                binaryreader.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    protected void moved(DownloadInfo.Part p, URL url, AtomicBoolean stop, Runnable notify) {
        p.setState(DownloadInfo.Part.States.RETRYING);
        notify.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fatal() {
        Object object = this.lock;
        synchronized (object) {
            return this.fatal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fatal(boolean b) {
        Object object = this.lock;
        synchronized (object) {
            this.fatal = b;
        }
    }

    String trimLen(String str, int len) {
        if (str.length() > len) {
            return String.valueOf(str.substring(0, len / 2)) + "..." + str.substring(str.length() - len / 2, str.length());
        }
        return str;
    }

    void downloadWorker(final DownloadInfo.Part p, final AtomicBoolean stop, final Runnable notify) throws InterruptedException {
        this.worker.blockExecute(new Runnable(){

            @Override
            public void run() {
                String f = "%s - Part: %d";
                Thread t = Thread.currentThread();
                t.setName(String.format(f, DirectMultipart.this.trimLen(DirectMultipart.this.info.getSource().toString(), 64), p.getNumber()));
                DirectMultipart.this.active.add(p);
                try {
                    try {
                        RetryWrap.wrap(stop, new RetryWrap.Wrap(){

                            @Override
                            public void proxy() {
                                (this).DirectMultipart.this.info.getProxy().set();
                            }

                            @Override
                            public void download() throws IOException {
                                p.setState(DownloadInfo.Part.States.DOWNLOADING);
                                notify.run();
                                DirectMultipart.this.downloadPart(this, p, stop, notify);
                            }

                            @Override
                            public void resume() {
                                p.setRetry(0);
                                (this).DirectMultipart.this.info.setRetry(0);
                            }

                            @Override
                            public void error(Throwable e) {
                                p.setRetry(p.getRetry() + 1);
                                int min = Integer.MAX_VALUE;
                                for (DownloadInfo.Part i : (this).DirectMultipart.this.active) {
                                    min = Math.min(min, i.getRetry());
                                }
                                (this).DirectMultipart.this.info.setRetry(min);
                                if (RetryWrap.retry(min)) {
                                    return;
                                }
                                DirectMultipart.this.fatal(true);
                            }

                            @Override
                            public boolean retry(int delay, Throwable e) {
                                p.setDelay(delay, e);
                                notify.run();
                                return !DirectMultipart.this.fatal();
                            }

                            @Override
                            public void moved(URL url) {
                                DirectMultipart.this.moved(p, url, stop, notify);
                            }
                        });
                        p.setState(DownloadInfo.Part.States.DONE);
                        notify.run();
                    }
                    catch (DownloadInterruptedError e) {
                        p.setState(DownloadInfo.Part.States.STOP, e);
                        notify.run();
                        DirectMultipart.this.fatal(true);
                        DirectMultipart.this.active.remove(p);
                    }
                    catch (RuntimeException e) {
                        p.setState(DownloadInfo.Part.States.ERROR, e);
                        notify.run();
                        DirectMultipart.this.fatal(true);
                        DirectMultipart.this.active.remove(p);
                    }
                }
                finally {
                    DirectMultipart.this.active.remove(p);
                }
            }
        });
        p.setState(DownloadInfo.Part.States.DOWNLOADING);
    }

    DownloadInfo.Part getPart() {
        for (DownloadInfo.Part p : this.info.getParts()) {
            if (!p.getState().equals((Object)DownloadInfo.Part.States.QUEUED)) continue;
            return p;
        }
        return null;
    }

    boolean done(AtomicBoolean stop) {
        if (stop.get()) {
            throw new DownloadInterruptedError("stop");
        }
        if (Thread.interrupted()) {
            throw new DownloadInterruptedError("interupted");
        }
        if (this.worker.active()) {
            return false;
        }
        return this.getPart() == null;
    }

    @Override
    public void download(AtomicBoolean stop, Runnable notify) {
        for (DownloadInfo.Part p : this.info.getParts()) {
            if (p.getState().equals((Object)DownloadInfo.Part.States.DONE)) continue;
            p.setState(DownloadInfo.Part.States.QUEUED);
        }
        this.info.setState(URLInfo.States.DOWNLOADING);
        notify.run();
        try {
            try {
                while (!this.done(stop)) {
                    DownloadInfo.Part p;
                    p = this.getPart();
                    if (p != null) {
                        this.downloadWorker(p, stop, notify);
                    } else {
                        this.worker.waitUntilNextTaskEnds();
                    }
                    if (!this.fatal()) continue;
                    this.worker.waitUntilTermination();
                    boolean interrupted = true;
                    for (DownloadInfo.Part pp : this.info.getParts()) {
                        Throwable e = pp.getException();
                        if (e == null || e instanceof DownloadInterruptedError) continue;
                        interrupted = false;
                    }
                    if (interrupted) {
                        throw new DownloadInterruptedError("multipart all interrupted");
                    }
                    throw new DownloadMultipartError(this.info);
                }
                this.info.setState(URLInfo.States.DONE);
                notify.run();
            }
            catch (InterruptedException e) {
                this.info.setState(URLInfo.States.STOP);
                notify.run();
                throw new DownloadInterruptedError(e);
            }
            catch (DownloadInterruptedError e) {
                this.info.setState(URLInfo.States.STOP);
                notify.run();
                throw e;
            }
            catch (RuntimeException e) {
                this.info.setState(URLInfo.States.ERROR);
                notify.run();
                throw e;
            }
        }
        finally {
            this.worker.shutdown();
        }
    }

    public static boolean canResume(DownloadInfo info, File targetFile) {
        if (!targetFile.exists()) {
            return false;
        }
        return targetFile.length() >= info.getCount();
    }
}

