/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget.info;

import com.github.axet.wget.RetryWrap;
import com.github.axet.wget.WGet;
import com.github.axet.wget.info.BrowserInfo;
import com.github.axet.wget.info.ProxyInfo;
import com.github.axet.wget.info.ex.DownloadRetry;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class URLInfo
extends BrowserInfo {
    private static final long serialVersionUID = 7260247341480497184L;
    public static int CONNECT_TIMEOUT = 10000;
    public static int READ_TIMEOUT = 10000;
    private URL source;
    private boolean extract = false;
    private Long length;
    private boolean range;
    private String contentType;
    private String contentFilename;
    private String cookie;
    private States state;
    private Throwable exception;
    private int delay;
    private int retry;
    private ProxyInfo proxy;

    public URLInfo(URL source) {
        this.source = source;
    }

    public HttpURLConnection openConnection() throws IOException {
        URL url = this.getSource();
        HttpURLConnection conn = this.getProxy() != null ? (HttpURLConnection)url.openConnection(this.getProxy().proxy) : (HttpURLConnection)url.openConnection();
        if (this.cookie != null) {
            conn.setRequestProperty("Cookie", this.cookie);
        }
        conn.setConnectTimeout(CONNECT_TIMEOUT);
        conn.setReadTimeout(READ_TIMEOUT);
        conn.setRequestProperty("User-Agent", this.getUserAgent());
        if (this.getReferer() != null) {
            conn.setRequestProperty("Referer", this.getReferer().toExternalForm());
        }
        return conn;
    }

    public void extract() {
        this.extract(new AtomicBoolean(false), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void extract(final AtomicBoolean stop, final Runnable notify) {
        try {
            Pattern cp;
            Matcher cm;
            HttpURLConnection conn = RetryWrap.wrap(stop, new RetryWrap.WrapReturn<HttpURLConnection>(){
                URL url;
                {
                    this.url = URLInfo.this.source;
                }

                @Override
                public void proxy() {
                    URLInfo.this.getProxy().set();
                }

                @Override
                public void resume() {
                    URLInfo.this.setRetry(0);
                }

                @Override
                public void error(Throwable e) {
                    URLInfo.this.setRetry(URLInfo.this.getRetry() + 1);
                }

                @Override
                public HttpURLConnection download() throws IOException {
                    return this.download(new URLInfo(this.url));
                }

                HttpURLConnection download(URLInfo url) throws IOException {
                    URLInfo.this.setState(States.EXTRACTING);
                    notify.run();
                    try {
                        return this.meta(URLInfo.this.extractRange(url));
                    }
                    catch (DownloadRetry e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        return this.meta(URLInfo.this.extractNormal(url));
                    }
                }

                HttpURLConnection meta(HttpURLConnection conn) throws IOException {
                    String urlmeta;
                    String[] url;
                    String[] vv;
                    String content;
                    String html;
                    Document doc;
                    Element link;
                    String ct = conn.getContentType();
                    if (ct == null) {
                        return conn;
                    }
                    String[] values = ct.split(";");
                    String contentType = values[0];
                    if (contentType.equals("text/html") && (link = (doc = Jsoup.parse((String)(html = WGet.getHtml(conn, stop)))).select("meta[http-equiv=refresh]").first()) != null && !(content = link.attr("content")).isEmpty() && (vv = content.split(";")).length > 1 && (url = (urlmeta = vv[1]).split("url=")).length > 1) {
                        URLInfo info = new URLInfo(new URL(url[1]));
                        info.setCookie(conn.getHeaderField("Set-cookie"));
                        info.setReferer(URLInfo.this.getSource());
                        HttpURLConnection conn2 = this.download(info);
                        URLInfo.this.setReferer(info.getReferer());
                        URLInfo.this.source = info.getSource();
                        if (info.getCookie() != null) {
                            URLInfo.this.setCookie(info.getCookie());
                        }
                        return conn2;
                    }
                    return conn;
                }

                @Override
                public boolean retry(int d, Throwable ee) {
                    URLInfo.this.setDelay(d, ee);
                    notify.run();
                    return RetryWrap.retry(URLInfo.this.getRetry());
                }

                @Override
                public void moved(URL u) {
                    URLInfo.this.setReferer(this.url);
                    this.url = u;
                    URLInfo.this.setState(States.RETRYING);
                    notify.run();
                }
            });
            this.setContentType(conn.getContentType());
            String contentDisposition = conn.getHeaderField("Content-Disposition");
            if (contentDisposition != null && (cm = (cp = Pattern.compile("filename=[\"]*([^\"]*)[\"]*")).matcher(contentDisposition)).find()) {
                this.setContentFilename(cm.group(1));
            }
            this.setEmpty(true);
            this.setState(States.EXTRACTING_DONE);
            notify.run();
        }
        catch (RuntimeException e) {
            this.setState(States.ERROR, e);
            throw e;
        }
    }

    public synchronized boolean empty() {
        return !this.extract;
    }

    public synchronized void setEmpty(boolean b) {
        this.extract = b;
    }

    protected HttpURLConnection extractRange(URLInfo url) throws IOException {
        HttpURLConnection conn = url.openConnection();
        conn.setRequestProperty("Range", "bytes=0-0");
        RetryWrap.check(conn);
        String range = conn.getHeaderField("Content-Range");
        if (range == null) {
            throw new RuntimeException("range not supported");
        }
        Pattern p = Pattern.compile("bytes \\d+-\\d+/(\\d+)");
        Matcher m = p.matcher(range);
        if (!m.find()) {
            throw new RuntimeException("range not supported");
        }
        this.setLength(new Long(m.group(1)));
        this.setRange(true);
        return conn;
    }

    protected HttpURLConnection extractNormal(URLInfo url) throws IOException {
        HttpURLConnection conn = url.openConnection();
        this.setRange(false);
        RetryWrap.check(conn);
        int len = conn.getContentLength();
        if (len >= 0) {
            this.setLength(new Long(len));
        }
        return conn;
    }

    public synchronized String getContentType() {
        return this.contentType;
    }

    public synchronized void setContentType(String ct) {
        this.contentType = ct;
    }

    public synchronized Long getLength() {
        return this.length;
    }

    public synchronized void setLength(Long l) {
        this.length = l;
    }

    public synchronized URL getSource() {
        return this.source;
    }

    public synchronized String getContentFilename() {
        return this.contentFilename;
    }

    public synchronized void setContentFilename(String f) {
        this.contentFilename = f;
    }

    public synchronized States getState() {
        return this.state;
    }

    public synchronized void setState(States state) {
        this.state = state;
        this.exception = null;
        this.delay = 0;
    }

    public synchronized void setState(States state, Throwable e) {
        this.state = state;
        this.exception = e;
        this.delay = 0;
    }

    public synchronized Throwable getException() {
        return this.exception;
    }

    protected synchronized void setException(Throwable exception) {
        this.exception = exception;
    }

    public synchronized int getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(int delay, Throwable e) {
        this.delay = delay;
        this.exception = e;
        this.state = States.RETRYING;
    }

    public synchronized boolean getRange() {
        return this.range;
    }

    public synchronized void setRange(boolean range) {
        this.range = range;
    }

    public synchronized ProxyInfo getProxy() {
        return this.proxy;
    }

    public synchronized void setProxy(ProxyInfo proxy) {
        this.proxy = proxy;
    }

    public synchronized String getCookie() {
        return this.cookie;
    }

    public synchronized void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public synchronized int getRetry() {
        return this.retry;
    }

    public synchronized void setRetry(int retry) {
        this.retry = retry;
    }

    public synchronized void resume(URLInfo old) {
        super.resume(old);
        this.proxy = new ProxyInfo(old.proxy);
    }

    public static enum States {
        EXTRACTING,
        EXTRACTING_DONE,
        DOWNLOADING,
        RETRYING,
        STOP,
        ERROR,
        DONE;

    }
}

