/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class ApacheIndex
extends HashMap<String, Index> {
    public static SimpleDateFormat APACHE_DATE = new SimpleDateFormat("d-MMM-yyyy HH:mm");
    public static Pattern DATE_SIZE = Pattern.compile("(([0-9][0-9])-([a-zA-Z][a-zA-Z][a-zA-Z])-([0-9][0-9][0-9][0-9]) ([0-9][0-9]:[0-9][0-9]))[ ]+([0-9]+)");
    protected long version;
    protected long now;

    public ApacheIndex(String url) throws IOException {
        long v = 0L;
        Document doc = Jsoup.connect((String)url).get();
        Elements aa = doc.select("a");
        for (Element a : aa) {
            Node n = a.nextSibling();
            String d = n.toString();
            Matcher m = DATE_SIZE.matcher(d);
            if (!m.find()) continue;
            Index i = new Index(m.group(1), m.group(6));
            v += i.date.getTime();
            this.put(a.attr("href"), i);
        }
        this.version = v / (long)this.size() / 1000L / 1000L;
        this.now = System.currentTimeMillis();
    }

    public long getVersion() {
        return this.version;
    }

    public long getNow() {
        return this.now;
    }

    public static class Index {
        public Date date;
        public long size;

        public Index(String d, String s) {
            try {
                this.date = APACHE_DATE.parse(d);
                this.size = Long.valueOf(s);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

