package com.github.axet.wget;

import java.util.ArrayList;

public class RangeSet extends ArrayList<RangeSet.Range> { // BitSet / RoaringBitmap for long values
    public static class Range {
        public long beg;
        public long end;

        public Range() {
        }

        public Range(Range r) {
            beg = r.beg;
            end = r.end;
        }

        public Range(long b, long e) {
            beg = b;
            end = e;
        }

        public long size() {
            return end - beg + 1;
        }

        @Override
        public String toString() {
            return String.format("[%d, %d]", beg, end);
        }
    }

    public RangeSet() {
    }

    public RangeSet(long beg, long end) {
        add(beg, end);
    }

    public void add(long beg, long end) {
        add(new Range(beg, end));
    }

    public int find(long beg) {
        for (int i = 0; i < size(); i++) {
            Range r = get(i);
            if (beg <= r.beg || beg <= r.end)
                return i;
        }
        return -1;
    }

    public void exclude(long beg, long end) {
        int i = find(beg);
        for (; i < size();) {
            Range r = get(i);
            if (beg <= r.beg && r.end <= end) { // consume whole ranges
                remove(i);
                continue;
            }
            if (r.beg <= beg && end <= r.end) { // inside
                remove(i);
                Range left = new Range(r.beg, beg - 1);
                Range right = new Range(end + 1, r.end);
                if (right.size() > 0)
                    add(i, right);
                if (left.size() > 0)
                    add(i, left);
            }
            if (r.beg <= beg && beg <= r.end) { // left unchanged
                r.end = beg - 1;
            }
            if (r.beg <= end && end <= r.end) { // right unchanged
                r.beg = end + 1;
            }
            i++;
        }
    }
}
