/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget.info;

import com.github.axet.wget.info.ProxyInfo;
import com.github.axet.wget.info.URLInfo;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class DownloadInfo
extends URLInfo {
    private static final long serialVersionUID = 1952592930771906713L;
    public static long PART_LENGTH = 0xA00000L;
    protected List<Part> parts;
    protected long partLength;
    protected long count;

    public DownloadInfo(URL source) {
        super(source);
    }

    public DownloadInfo(URL source, ProxyInfo p) {
        super(source);
        this.setProxy(p);
    }

    public synchronized boolean multipart() {
        if (!this.getRange()) {
            return false;
        }
        return this.parts != null;
    }

    public synchronized void reset() {
        this.setCount(0L);
        if (this.parts != null) {
            for (Part p : this.parts) {
                p.setCount(0L);
                p.setState(Part.States.QUEUED);
            }
        }
    }

    public synchronized void calculate() {
        this.setCount(0L);
        for (Part p : this.getParts()) {
            this.setCount(this.getCount() + p.getCount());
        }
    }

    public synchronized List<Part> getParts() {
        return this.parts;
    }

    public synchronized long getPartLength() {
        return this.partLength;
    }

    public synchronized void enableMultipart() {
        this.enableMultipart(PART_LENGTH);
    }

    public synchronized void enableMultipart(long partLength) {
        if (this.empty()) {
            throw new RuntimeException("Empty Download info, cant set multipart");
        }
        if (!this.getRange()) {
            throw new RuntimeException("Server does not support RANGE, cant set multipart");
        }
        this.partLength = partLength;
        long len = this.getLength();
        long last = len - 1L;
        long count = len / partLength;
        if (len % partLength > 0L) {
            ++count;
        }
        if (count > 2L) {
            this.parts = new ArrayList<Part>();
            long start = 0L;
            int i = 0;
            while ((long)i < count) {
                long end = start + partLength - 1L;
                if (end > last) {
                    end = last;
                }
                Part part = new Part();
                part.setNumber(i);
                part.setStart(start);
                part.setEnd(end);
                part.setState(Part.States.QUEUED);
                this.parts.add(part);
                start = end + 1L;
                ++i;
            }
        }
    }

    public synchronized boolean canResume(DownloadInfo oldInfo) {
        if (!oldInfo.getRange()) {
            return false;
        }
        if (oldInfo.getContentFilename() != null && this.getContentFilename() != null ? !oldInfo.getContentFilename().equals(this.getContentFilename()) : oldInfo.getContentFilename() != null || this.getContentFilename() != null) {
            return false;
        }
        if (oldInfo.getLength() != null && this.getLength() != null ? !oldInfo.getLength().equals(this.getLength()) : oldInfo.getLength() != null || this.getLength() != null) {
            return false;
        }
        return !(oldInfo.getContentType() != null && this.getContentType() != null ? !oldInfo.getContentType().equals(this.getContentType()) : oldInfo.getContentType() != null || this.getContentType() != null);
    }

    public synchronized void resume(DownloadInfo oldSource) {
        super.resume(oldSource);
        this.parts = new ArrayList<Part>();
        for (int i = 0; i < oldSource.parts.size(); ++i) {
            this.parts.add(new Part(this.parts.get(i)));
        }
        this.partLength = oldSource.partLength;
        this.count = oldSource.count;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    @Override
    public void extract(AtomicBoolean stop, Runnable notify) {
        super.extract(stop, notify);
    }

    public static class Part {
        protected long start;
        protected long end;
        protected long number;
        protected long count;
        protected States state;
        protected Throwable exception;
        protected int delay;
        protected int retry;

        public Part() {
        }

        public Part(Part copy) {
            this.start = copy.start;
            this.end = copy.end;
            this.number = copy.number;
            this.count = copy.count;
            this.state = copy.state;
            this.exception = copy.exception;
            this.delay = copy.delay;
            this.retry = copy.retry;
        }

        public synchronized long getStart() {
            return this.start;
        }

        public synchronized void setStart(long start) {
            this.start = start;
        }

        public synchronized long getEnd() {
            return this.end;
        }

        public synchronized void setEnd(long end) {
            this.end = end;
        }

        public synchronized long getNumber() {
            return this.number;
        }

        public synchronized void setNumber(long number) {
            this.number = number;
        }

        public synchronized long getLength() {
            return this.end - this.start + 1L;
        }

        public synchronized long getCount() {
            return this.count;
        }

        public synchronized void setCount(long count) {
            this.count = count;
        }

        public synchronized States getState() {
            return this.state;
        }

        public synchronized void setState(States state) {
            this.state = state;
            this.exception = null;
        }

        public synchronized void setState(States state, Throwable e) {
            this.state = state;
            this.exception = e;
        }

        public synchronized Throwable getException() {
            return this.exception;
        }

        public synchronized void setException(Throwable exception) {
            this.exception = exception;
        }

        public synchronized int getDelay() {
            return this.delay;
        }

        public synchronized void setDelay(int delay, Throwable e) {
            this.state = States.RETRYING;
            this.delay = delay;
            this.exception = e;
        }

        public synchronized int getRetry() {
            return this.retry;
        }

        public synchronized void setRetry(int retry) {
            this.retry = retry;
        }

        public static enum States {
            QUEUED,
            DOWNLOADING,
            RETRYING,
            ERROR,
            STOP,
            DONE;

        }
    }
}

