/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.errors.DownloadError;
import com.github.axet.wget.errors.DownloadIOCodeError;
import com.github.axet.wget.errors.DownloadIOError;
import com.github.axet.wget.errors.DownloadInterruptedError;
import com.github.axet.wget.errors.DownloadMoved;
import com.github.axet.wget.errors.DownloadRetry;
import com.github.axet.wget.errors.ProxyAuth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;

public class RetryWrap {
    public static int RETRY_DELAY = 3;
    public static int RETRY_COUNT = 5;

    static <T> void moved(AtomicBoolean stop, WrapReturn<T> r, DownloadMoved e) {
        if (stop.get()) {
            throw new DownloadInterruptedError("stop");
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new DownloadInterruptedError("interrrupted");
        }
        r.moved(e.getMoved());
    }

    static <T> void retry(AtomicBoolean stop, WrapReturn<T> r, RuntimeException e) {
        r.error(e);
        for (int i = RETRY_DELAY; i >= 0; --i) {
            if (!r.retry(i, e)) {
                throw new DownloadError(e);
            }
            if (stop.get()) {
                throw new DownloadInterruptedError("stop");
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new DownloadInterruptedError("interrrupted");
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e1) {
                throw new DownloadInterruptedError(e1);
            }
        }
    }

    public static <T> T run(AtomicBoolean stop, WrapReturn<T> r) {
        while (true) {
            if (stop.get()) {
                throw new DownloadInterruptedError("stop");
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new DownloadInterruptedError("interrupted");
            }
            try {
                try {
                    try {
                        T t = r.download();
                        if (stop.get()) {
                            throw new DownloadInterruptedError("stop");
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            throw new DownloadInterruptedError("interrupted");
                        }
                        return t;
                    }
                    catch (ProxyAuth e) {
                        try {
                            r.proxy();
                            T t = r.download();
                            if (stop.get()) {
                                throw new DownloadInterruptedError("stop");
                            }
                            if (Thread.currentThread().isInterrupted()) {
                                throw new DownloadInterruptedError("interrupted");
                            }
                            return t;
                        }
                        catch (ProxyAuth e2) {
                            throw new DownloadError(e2);
                        }
                    }
                }
                catch (SocketException e) {
                    throw new DownloadRetry(e);
                }
                catch (ProtocolException e) {
                    throw new DownloadRetry(e);
                }
                catch (HttpRetryException e) {
                    throw new DownloadRetry(e);
                }
                catch (InterruptedIOException e) {
                    throw new DownloadRetry(e);
                }
                catch (UnknownHostException e) {
                    throw new DownloadRetry(e);
                }
                catch (FileNotFoundException e) {
                    throw new DownloadError(e);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new DownloadInterruptedError(e);
                    }
                    throw new DownloadIOError(e);
                }
            }
            catch (DownloadMoved e) {
                RetryWrap.moved(stop, r, e);
                continue;
            }
            catch (DownloadRetry e) {
                RetryWrap.retry(stop, r, e);
                continue;
            }
            break;
        }
    }

    public static <T> T wrap(AtomicBoolean stop, WrapReturn<T> r) {
        return RetryWrap.run(stop, r);
    }

    public static void wrap(AtomicBoolean stop, final Wrap r) {
        WrapReturn<Object> rr = new WrapReturn<Object>(){

            @Override
            public Object download() throws IOException {
                r.download();
                return null;
            }

            @Override
            public void resume() {
                r.resume();
            }

            @Override
            public void error(Throwable e) {
                r.error(e);
            }

            @Override
            public boolean retry(int delay, Throwable e) {
                return r.retry(delay, e);
            }

            @Override
            public void moved(URL url) {
                r.moved(url);
            }

            @Override
            public void proxy() {
                r.proxy();
            }
        };
        RetryWrap.run(stop, rr);
    }

    public static void check(HttpURLConnection c) throws IOException {
        int code = c.getResponseCode();
        switch (code) {
            case 200: 
            case 206: {
                return;
            }
            case 301: 
            case 302: {
                throw new DownloadMoved(c);
            }
            case 407: {
                throw new ProxyAuth(c);
            }
            case 403: {
                throw new DownloadIOCodeError(code);
            }
            case 416: {
                throw new DownloadIOCodeError(416);
            }
        }
    }

    public static boolean retry(int r) {
        return RETRY_COUNT < 0 || r <= RETRY_COUNT;
    }

    public static interface Wrap {
        public void proxy();

        public void resume();

        public void error(Throwable var1);

        public boolean retry(int var1, Throwable var2);

        public void moved(URL var1);

        public void download() throws IOException;
    }

    public static interface WrapReturn<T> {
        public void proxy();

        public void resume();

        public void error(Throwable var1);

        public boolean retry(int var1, Throwable var2);

        public void moved(URL var1);

        public T download() throws IOException;
    }
}

