/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget.info;

import com.github.axet.wget.RetryWrap;
import com.github.axet.wget.WGet;
import com.github.axet.wget.errors.DownloadRetry;
import com.github.axet.wget.info.BrowserInfo;
import com.github.axet.wget.info.ProxyInfo;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class URLInfo
extends BrowserInfo {
    private static final long serialVersionUID = 7260247341480497184L;
    public static Pattern FILENAME = Pattern.compile("filename=[\"]*([^\"]*)[\"]*");
    public static Pattern BYTES = Pattern.compile("bytes \\d+-\\d+/(\\d+)");
    public static int CONNECT_TIMEOUT = 10000;
    public static int READ_TIMEOUT = 10000;
    private URL source;
    protected URL url;
    private boolean extract = false;
    private Long length;
    private boolean range;
    private String contentType;
    private String contentFilename;
    private String cookie;
    private States state;
    private Throwable exception;
    private int delay;
    private int retry;
    private ProxyInfo proxy;

    public static String toString(Throwable e) {
        ArrayList<String> ss = new ArrayList<String>(Arrays.asList(DownloadRetry.class.getPackage().getName(), Throwable.class.getPackage().getName(), IOException.class.getPackage().getName()));
        if (ss.contains(e.getClass().getPackage().getName())) {
            return e.getClass().getSimpleName() + ": " + e.getMessage();
        }
        return e.getClass().getCanonicalName() + ": " + e.getMessage();
    }

    public static Throwable toThroable(String s) {
        Pattern p = Pattern.compile("(.*): (.*)");
        Matcher m = p.matcher(s);
        if (m.matches()) {
            String n = m.group(1);
            String msg = m.group(2);
            try {
                Class<?> k = Class.forName(DownloadRetry.class.getPackage().getName() + "." + n);
                return (Throwable)k.getConstructor(String.class).newInstance(msg);
            }
            catch (Exception e) {
                try {
                    Class<?> k = Class.forName(RuntimeException.class.getPackage().getName() + "." + n);
                    return (Throwable)k.getConstructor(String.class).newInstance(msg);
                }
                catch (Exception e1) {
                    try {
                        Class<?> k = Class.forName(IOException.class.getPackage().getName() + "." + n);
                        return (Throwable)k.getConstructor(String.class).newInstance(msg);
                    }
                    catch (Exception e2) {
                        try {
                            Class<?> k = Class.forName(n);
                            return (Throwable)k.getConstructor(String.class).newInstance(msg);
                        }
                        catch (Exception e3) {
                            return new RuntimeException(s);
                        }
                    }
                }
            }
        }
        return new RuntimeException(s);
    }

    public URLInfo() {
    }

    public URLInfo(URL source) {
        this.source = source;
        this.url = source;
    }

    public URLInfo(JSONObject o) {
        this.load(o);
    }

    public HttpURLConnection openConnection() throws IOException {
        HttpURLConnection conn = this.getProxy() != null ? (HttpURLConnection)this.url.openConnection(this.getProxy().proxy) : (HttpURLConnection)this.url.openConnection();
        if (this.cookie != null) {
            conn.setRequestProperty("Cookie", this.cookie);
        }
        conn.setConnectTimeout(CONNECT_TIMEOUT);
        conn.setReadTimeout(READ_TIMEOUT);
        conn.setRequestProperty("User-Agent", this.getUserAgent());
        if (this.getReferer() != null) {
            conn.setRequestProperty("Referer", this.getReferer().toExternalForm());
        }
        return conn;
    }

    public void extract() {
        this.extract(new AtomicBoolean(false), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void extract(final AtomicBoolean stop, final Runnable notify) {
        try {
            Matcher cm;
            HttpURLConnection conn = RetryWrap.wrap(stop, new RetryWrap.WrapReturn<HttpURLConnection>(){

                @Override
                public void proxy() {
                    URLInfo.this.getProxy().set();
                }

                @Override
                public void resume() {
                    URLInfo.this.setRetry(0);
                }

                @Override
                public void error(Throwable e) {
                    URLInfo.this.setRetry(URLInfo.this.getRetry() + 1);
                }

                @Override
                public HttpURLConnection download() throws IOException {
                    URLInfo.this.setState(States.EXTRACTING);
                    notify.run();
                    try {
                        return this.meta(URLInfo.this.extractRange());
                    }
                    catch (DownloadRetry e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        return this.meta(URLInfo.this.extractNormal());
                    }
                }

                HttpURLConnection meta(HttpURLConnection conn) throws IOException {
                    String urlmeta;
                    String[] uu;
                    String[] vv;
                    String content;
                    String html;
                    Document doc;
                    Element link;
                    String ct = conn.getContentType();
                    if (ct == null) {
                        return conn;
                    }
                    String[] values = ct.split(";");
                    String contentType = values[0];
                    if (contentType.equals("text/html") && (link = (doc = Jsoup.parse((String)(html = WGet.getHtml(conn, stop)))).select("meta[http-equiv=refresh]").first()) != null && !(content = link.attr("content")).isEmpty() && (vv = content.split(";")).length > 1 && (uu = (urlmeta = vv[1]).split("url=")).length > 1) {
                        URLInfo.this.setReferer(URLInfo.this.url);
                        URLInfo.this.url = new URL(uu[1]);
                        String c = conn.getHeaderField("Set-cookie");
                        if (c != null) {
                            URLInfo.this.setCookie(c);
                        }
                        return this.download();
                    }
                    return conn;
                }

                @Override
                public boolean retry(int d, Throwable ee) {
                    URLInfo.this.setDelay(d, ee);
                    notify.run();
                    return RetryWrap.retry(URLInfo.this.getRetry());
                }

                @Override
                public void moved(URL u) {
                    URLInfo.this.setReferer(URLInfo.this.url);
                    URLInfo.this.url = u;
                    URLInfo.this.setState(States.RETRYING);
                    notify.run();
                }
            });
            this.setContentType(conn.getContentType());
            String contentDisposition = conn.getHeaderField("Content-Disposition");
            if (contentDisposition != null && (cm = FILENAME.matcher(contentDisposition)).find()) {
                this.setContentFilename(cm.group(1));
            }
            this.setEmpty(true);
            this.setState(States.EXTRACTING_DONE);
            notify.run();
        }
        catch (RuntimeException e) {
            this.setState(States.ERROR, e);
            throw e;
        }
    }

    public synchronized boolean empty() {
        return !this.extract;
    }

    public synchronized void setEmpty(boolean b) {
        this.extract = b;
    }

    protected HttpURLConnection extractRange() throws IOException {
        HttpURLConnection conn = this.openConnection();
        conn.setRequestProperty("Range", "bytes=0-0");
        RetryWrap.check(conn);
        String range = conn.getHeaderField("Content-Range");
        if (range == null) {
            throw new RuntimeException("range not supported");
        }
        Matcher m = BYTES.matcher(range);
        if (!m.find()) {
            throw new RuntimeException("range not supported");
        }
        this.setLength(new Long(m.group(1)));
        this.setRange(true);
        return conn;
    }

    protected HttpURLConnection extractNormal() throws IOException {
        HttpURLConnection conn = this.openConnection();
        this.setRange(false);
        RetryWrap.check(conn);
        int len = conn.getContentLength();
        if (len >= 0) {
            this.setLength(new Long(len));
        }
        return conn;
    }

    public synchronized String getContentType() {
        return this.contentType;
    }

    public synchronized void setContentType(String ct) {
        this.contentType = ct;
    }

    public synchronized Long getLength() {
        return this.length;
    }

    public synchronized void setLength(Long l) {
        this.length = l;
    }

    public synchronized URL getSource() {
        return this.source;
    }

    public synchronized String getContentFilename() {
        return this.contentFilename;
    }

    public synchronized void setContentFilename(String f) {
        this.contentFilename = f;
    }

    public synchronized States getState() {
        return this.state;
    }

    public synchronized void setState(States state) {
        this.state = state;
        this.exception = null;
        this.delay = 0;
    }

    public synchronized void setState(States state, Throwable e) {
        this.state = state;
        this.exception = e;
        this.delay = 0;
    }

    public synchronized Throwable getException() {
        return this.exception;
    }

    protected synchronized void setException(Throwable exception) {
        this.exception = exception;
    }

    public synchronized int getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(int delay, Throwable e) {
        this.delay = delay;
        this.exception = e;
        this.state = States.RETRYING;
    }

    public synchronized boolean getRange() {
        return this.range;
    }

    public synchronized void setRange(boolean range) {
        this.range = range;
    }

    public synchronized ProxyInfo getProxy() {
        return this.proxy;
    }

    public synchronized void setProxy(ProxyInfo proxy) {
        this.proxy = proxy;
    }

    public synchronized String getCookie() {
        return this.cookie;
    }

    public synchronized void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public synchronized int getRetry() {
        return this.retry;
    }

    public synchronized void setRetry(int retry) {
        this.retry = retry;
    }

    public synchronized void resume(URLInfo old) {
        super.resume(old);
        this.proxy = new ProxyInfo(old.proxy);
    }

    @Override
    public JSONObject save() {
        JSONObject o = super.save();
        o.put("source", (Object)this.source.toExternalForm());
        o.put("url", (Object)this.url.toExternalForm());
        o.put("extract", this.extract);
        o.put("length", (Object)this.length);
        o.put("range", this.range);
        o.put("content_type", (Object)this.contentType);
        o.put("content_filename", (Object)this.contentFilename);
        o.put("cookie", (Object)this.cookie);
        o.put("state", (Object)this.state.toString());
        if (this.exception != null) {
            o.put("exception", (Object)URLInfo.toString(this.exception));
        }
        return o;
    }

    @Override
    public void load(JSONObject o) {
        super.load(o);
        try {
            this.source = new URL(o.getString("source"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            this.url = new URL(o.getString("url"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.extract = o.getBoolean("extract");
        this.length = o.getLong("length");
        this.range = o.getBoolean("range");
        this.contentType = o.getString("content_type");
        this.contentFilename = o.optString("content_filename", null);
        this.cookie = o.optString("cookie", null);
        this.state = States.valueOf(o.getString("state"));
        String e = o.optString("exception", null);
        if (e != null) {
            this.exception = URLInfo.toThroable(e);
        }
    }

    public static enum States {
        EXTRACTING,
        EXTRACTING_DONE,
        DOWNLOADING,
        RETRYING,
        STOP,
        ERROR,
        DONE;

    }
}

