/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import com.github.axet.wget.Direct;
import com.github.axet.wget.RetryWrap;
import com.github.axet.wget.errors.DownloadInterruptedError;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.URLInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;

public class DirectRange
extends Direct {
    public DirectRange(DownloadInfo info, File target) {
        super(info, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadPart(RetryWrap.Wrap w, DownloadInfo info, AtomicBoolean stop, Runnable notify) throws IOException {
        RandomAccessFile fos = null;
        BufferedInputStream binaryreader = null;
        try {
            HttpURLConnection conn = info.openConnection();
            File f = this.target;
            if (!f.exists()) {
                f.createNewFile();
            }
            info.setDownloaded(FileUtils.sizeOf((File)f));
            if (info.getDownloaded() >= info.getLength()) {
                notify.run();
                return;
            }
            fos = new RandomAccessFile(f, "rw");
            if (info.getDownloaded() > 0L) {
                conn.setRequestProperty("Range", "bytes=" + info.getDownloaded() + "-");
                fos.seek(info.getDownloaded());
            }
            byte[] bytes = new byte[BUF_SIZE];
            int read = 0;
            RetryWrap.check(conn);
            binaryreader = new BufferedInputStream(conn.getInputStream());
            while ((read = binaryreader.read(bytes)) > 0) {
                w.resume();
                fos.write(bytes, 0, read);
                info.setDownloaded(info.getDownloaded() + (long)read);
                notify.run();
                if (stop.get()) {
                    throw new DownloadInterruptedError("stop");
                }
                if (!Thread.interrupted()) continue;
                throw new DownloadInterruptedError("interrupted");
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (binaryreader != null) {
                binaryreader.close();
            }
        }
    }

    @Override
    public void download(final AtomicBoolean stop, final Runnable notify) {
        this.info.setState(URLInfo.States.DOWNLOADING);
        notify.run();
        try {
            RetryWrap.wrap(stop, new RetryWrap.Wrap(){

                @Override
                public void proxy() {
                    DirectRange.this.info.getProxy().set();
                }

                @Override
                public void resume() {
                    DirectRange.this.info.setRetry(0);
                }

                @Override
                public void error(Throwable e) {
                    DirectRange.this.info.setRetry(DirectRange.this.info.getRetry() + 1);
                }

                @Override
                public void download() throws IOException {
                    DirectRange.this.info.setState(URLInfo.States.DOWNLOADING);
                    notify.run();
                    DirectRange.this.downloadPart(this, DirectRange.this.info, stop, notify);
                }

                @Override
                public boolean retry(int delay, Throwable e) {
                    DirectRange.this.info.setDelay(delay, e);
                    notify.run();
                    return RetryWrap.retry(DirectRange.this.info.getRetry());
                }

                @Override
                public void moved(URL url) {
                    DownloadInfo old = DirectRange.this.info;
                    DirectRange.this.info = new DownloadInfo(url);
                    DirectRange.this.info.extract(stop, notify);
                    if (DirectRange.this.info.canResume(old)) {
                        DirectRange.this.info.resume(old);
                    }
                    DirectRange.this.info.setState(URLInfo.States.RETRYING);
                    notify.run();
                }
            });
            this.info.setState(URLInfo.States.DONE);
            notify.run();
        }
        catch (DownloadInterruptedError e) {
            this.info.setState(URLInfo.States.STOP);
            notify.run();
            throw e;
        }
        catch (RuntimeException e) {
            this.info.setState(URLInfo.States.ERROR);
            notify.run();
            throw e;
        }
    }

    public static boolean canResume(DownloadInfo info, File targetFile) {
        return !(targetFile.exists() ? info.getDownloaded() != targetFile.length() : info.getDownloaded() > 0L);
    }
}

