/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.wget;

import java.util.ArrayList;
import java.util.Comparator;

public class RangeSet
extends ArrayList<Range> {
    public RangeSet() {
    }

    public RangeSet(long beg, long end) {
        this.add(beg, end);
    }

    public void add(long beg, long end) {
        this.add(new Range(beg, end));
    }

    public int lower(long beg) {
        for (int i = 0; i < this.size(); ++i) {
            Range r = (Range)this.get(i);
            if (!r.lower(beg)) continue;
            return i;
        }
        return -1;
    }

    public int contains(long v) {
        for (int i = 0; i < this.size(); ++i) {
            Range r = (Range)this.get(i);
            if (!r.contains(v)) continue;
            return i;
        }
        return -1;
    }

    public void exclude(long beg, long end) {
        int i = this.lower(beg);
        if (i == -1) {
            return;
        }
        while (i < this.size()) {
            Range r = (Range)this.get(i);
            if (beg <= r.beg && r.end <= end) {
                this.remove(i);
                continue;
            }
            if (r.beg <= beg && end <= r.end) {
                this.remove(i);
                Range left = new Range(r.beg, beg - 1L);
                Range right = new Range(end + 1L, r.end);
                if (right.size() > 0L) {
                    this.add(i, right);
                }
                if (left.size() > 0L) {
                    this.add(i, left);
                }
            }
            if (r.beg <= beg && beg <= r.end) {
                r.end = beg - 1L;
            }
            if (r.beg <= end && end <= r.end) {
                r.beg = end + 1L;
            }
            ++i;
        }
    }

    public void include(long beg, long end) {
        this.exclude(beg, end);
        this.add(beg, end);
        this.sort();
    }

    public void merge() {
        for (int i = 0; i < this.size(); ++i) {
            Range r1 = (Range)this.get(i);
            for (int k = i + 1; k < this.size(); ++k) {
                Range r2 = (Range)this.get(k);
                if (!r2.contains(r1.beg) && !r2.contains(r1.end)) continue;
                r1.merge(r2);
                this.remove(k);
                k = i;
            }
        }
    }

    public void merge(long beg, long end) {
        this.exclude(beg, end);
        long b = beg;
        long e = end;
        int i = this.contains(beg - 1L);
        if (i != -1) {
            b = ((Range)this.get((int)i)).beg;
            this.remove(i);
        }
        if ((i = this.contains(end + 1L)) != -1) {
            e = ((Range)this.get((int)i)).end;
            this.remove(i);
        }
        this.add(b, e);
        this.sort();
    }

    public void sort() {
        this.sort(new RangeSort());
    }

    public static class RangeSort
    implements Comparator<Range> {
        @Override
        public int compare(Range o1, Range o2) {
            return Long.valueOf(o1.beg).compareTo(o2.beg);
        }
    }

    public static class Range {
        public long beg;
        public long end;

        public Range() {
        }

        public Range(Range r) {
            this.beg = r.beg;
            this.end = r.end;
        }

        public Range(long b, long e) {
            this.beg = b;
            this.end = e;
        }

        public long size() {
            return this.end - this.beg + 1L;
        }

        public boolean contains(long v) {
            return this.beg >= v && v <= this.end;
        }

        public boolean lower(long beg) {
            return beg <= this.beg || beg <= this.end;
        }

        public void merge(Range r2) {
            if (r2.beg < this.beg) {
                this.beg = r2.beg;
            }
            if (r2.end > this.end) {
                this.end = r2.end;
            }
        }

        public String toString() {
            return String.format("[%d, %d]", this.beg, this.end);
        }
    }
}

