/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import net.lingala.zip4j.NativeFile;
import net.lingala.zip4j.model.enums.RandomAccessFileMode;
import net.lingala.zip4j.util.FileUtils;
import net.lingala.zip4j.util.InternalZipConstants;

public class NativeStorage {
    protected File f;

    public NativeStorage(NativeStorage v) {
        this.f = new File(this.f.getPath());
    }

    public NativeStorage(File f) {
        this.f = f;
    }

    public NativeStorage(String f) {
        this.f = new File(f);
    }

    public NativeFile read() throws FileNotFoundException {
        return new NativeFile(this.f, RandomAccessFileMode.READ.getValue());
    }

    public NativeFile write() throws FileNotFoundException {
        return new NativeFile(this.f, RandomAccessFileMode.WRITE.getValue());
    }

    public NativeStorage open(String name) {
        return new NativeStorage(new File(this.f, name));
    }

    public boolean exists() {
        return this.f.exists();
    }

    public boolean canRead() {
        return this.f.canRead();
    }

    public boolean canWrite() {
        return this.f.canWrite();
    }

    public boolean isHidden() {
        return this.f.isHidden();
    }

    public NativeStorage getParent() {
        return new NativeStorage(this.f.getParentFile());
    }

    public NativeStorage getParentFile() {
        return this.getParent();
    }

    public String getName() {
        return this.f.getName();
    }

    public String getAbsolutePath() {
        return this.f.getAbsolutePath();
    }

    public boolean isDirectory() {
        return this.f.isDirectory();
    }

    public long lastModified() {
        return this.f.lastModified();
    }

    public long length() {
        return this.f.length();
    }

    public boolean renameTo(NativeStorage to) {
        return this.f.renameTo(to.f);
    }

    public void setLastModified(long l) {
        this.f.setLastModified(l);
    }

    public void setReadOnly() {
        this.f.setReadOnly();
    }

    public boolean mkdirs() {
        return this.f.mkdirs();
    }

    public boolean delete() {
        return this.f.delete();
    }

    public NativeStorage[] listFiles() {
        File[] ff = this.f.listFiles();
        if (ff == null) {
            return null;
        }
        NativeStorage[] nn = new NativeStorage[ff.length];
        for (int i = 0; i < nn.length; ++i) {
            nn[i] = new NativeStorage(ff[i]);
        }
        return nn;
    }

    public NativeStorage[] listFiles(FilenameFilter filter) {
        File[] ff = this.f.listFiles();
        if (ff == null) {
            return null;
        }
        ArrayList<NativeStorage> nn = new ArrayList<NativeStorage>();
        for (int i = 0; i < ff.length; ++i) {
            NativeStorage s = new NativeStorage(ff[i]);
            if (!filter.accept(s.getParent(), s.getName())) continue;
            nn.add(s);
        }
        return nn.toArray(new NativeStorage[0]);
    }

    public String getPath() {
        return this.f.getPath();
    }

    public String getCanonicalPath() throws IOException {
        return this.f.getCanonicalPath();
    }

    public NativeStorage getCanonicalFile() {
        return this;
    }

    public Path toPath() {
        return this.f.toPath();
    }

    public boolean renameTo(File to) {
        return this.f.renameTo(to);
    }

    public String getRelPath(NativeStorage child) {
        String filePath;
        String tmpFileName;
        String rootFolderFileRef = this.getPath();
        if (!rootFolderFileRef.endsWith(InternalZipConstants.FILE_SEPARATOR)) {
            rootFolderFileRef = rootFolderFileRef + InternalZipConstants.FILE_SEPARATOR;
        }
        if ((tmpFileName = (filePath = child.getPath()).substring(rootFolderFileRef.length())).startsWith(System.getProperty("file.separator"))) {
            tmpFileName = tmpFileName.substring(1);
        }
        return tmpFileName;
    }

    public boolean isSymbolicLink() {
        return Files.isSymbolicLink(this.f.toPath());
    }

    public Path readSymbolicLink() throws IOException {
        return Files.readSymbolicLink(this.f.toPath());
    }

    public byte[] getFileAttributes() {
        return FileUtils.getFileAttributes(this.toPath());
    }

    public static interface FilenameFilter {
        public boolean accept(NativeStorage var1, String var2);
    }
}

