/*
 * Decompiled with CFR 0.152.
 */
package enums;

import enums.EnumExceptionCode;
import exception.Ppt2PicException;

public enum EnumPptSuffix {
    PPT("ppt", ""),
    PPTX("pptx", "");

    private String code;
    private String desc;

    private EnumPptSuffix(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Boolean checkIsPpt(String fileSuffix) {
        if (EnumPptSuffix.PPT.code.equalsIgnoreCase(fileSuffix) || EnumPptSuffix.PPTX.code.equalsIgnoreCase(fileSuffix)) {
            return true;
        }
        return false;
    }

    public static EnumPptSuffix gainEnumBySuffix(String fileSuffix) {
        if (EnumPptSuffix.PPT.code.equalsIgnoreCase(fileSuffix)) {
            return PPT;
        }
        if (EnumPptSuffix.PPTX.code.equalsIgnoreCase(fileSuffix)) {
            return PPTX;
        }
        throw new Ppt2PicException(EnumExceptionCode.PPT_SUFFIX_IS_NOT_RIGHT);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

