/*
 * Decompiled with CFR 0.152.
 */
package service;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextRun;
import org.apache.poi.hslf.usermodel.HSLFTextShape;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.usermodel.Shape;
import org.apache.poi.sl.usermodel.Slide;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextRun;
import org.apache.poi.xslf.usermodel.XSLFTextShape;

public abstract class ApachePoiHandle {
    private SlideShow slideShow;
    private Integer width;
    private Integer height;
    private List<Slide> slideList;

    public ApachePoiHandle(SlideShow slideShow) {
        this.slideShow = slideShow;
        Dimension pageSize = slideShow.getPageSize();
        this.width = (int)(pageSize.getWidth() * 1.0);
        this.height = (int)(pageSize.getHeight() * 1.0);
        this.slideList = slideShow.getSlides();
    }

    public List<ByteArrayOutputStream> gainPptpicStream() {
        List<ByteArrayOutputStream> picStreamList = this.gainPptPicStream(this.width, this.height, this.slideList);
        return picStreamList;
    }

    public List<ByteArrayOutputStream> gainPptPicStream(Integer width, Integer height, List<Slide> slideList) {
        ArrayList<ByteArrayOutputStream> picStreamList = new ArrayList<ByteArrayOutputStream>();
        for (Slide slide : slideList) {
            this.handlePptPageDetail(slide.getShapes());
            ByteArrayOutputStream picStream = this.gainBufferdImageStream(width, height, slide);
            picStreamList.add(picStream);
        }
        return picStreamList;
    }

    public void handlePptPageDetail(List<Shape> shapeList) {
        for (Shape shape : shapeList) {
            if (shape instanceof XSLFTextShape) {
                XSLFTextShape txtshape = (XSLFTextShape)shape;
                for (XSLFTextParagraph textPara : txtshape.getTextParagraphs()) {
                    List textRunList = textPara.getTextRuns();
                    for (XSLFTextRun textRun : textRunList) {
                        textRun.setFontFamily("\u5b8b\u4f53");
                    }
                }
                continue;
            }
            if (!(shape instanceof HSLFTextShape)) continue;
            HSLFTextShape hslfTextShape = (HSLFTextShape)shape;
            for (HSLFTextParagraph textParagraph : hslfTextShape.getTextParagraphs()) {
                List textRuns = textParagraph.getTextRuns();
                for (HSLFTextRun hslfTextRun : textRuns) {
                    hslfTextRun.setFontFamily("\u5b8b\u4f53");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream gainBufferdImageStream(Integer width, Integer height, Slide slide) {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D graphics = img.createGraphics();
        DrawFactory.getInstance((Graphics2D)graphics).fixFonts(graphics);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics.scale(1.0, 1.0);
        slide.draw(graphics);
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", bs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            graphics.dispose();
            img.flush();
        }
        return bs;
    }
}

