/*
 * Decompiled with CFR 0.152.
 */
package service;

import enums.EnumExceptionCode;
import enums.EnumPptFrom;
import enums.EnumPptSuffix;
import exception.Ppt2PicException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import service.PptOperate;
import service.PptxOperate;

public class Ppt2PicHandle {
    private String fontStyle;
    private String picSuffix;

    public List<ByteArrayOutputStream> handlePpt2Pic(EnumPptFrom enumPptFrom) throws Exception {
        Pair<InputStream, EnumPptSuffix> pptDetailPair = null;
        switch (enumPptFrom) {
            case ADDRESS: {
                String pptAddress = enumPptFrom.getPptFromDetail();
                pptDetailPair = this.checkAddressIsPpt(pptAddress);
                break;
            }
            case URL: {
                String pptUrl = enumPptFrom.getPptFromDetail();
                pptDetailPair = this.checkUrlIsPpt(pptUrl);
                break;
            }
        }
        List<ByteArrayOutputStream> picStreamList = this.handlePpt2Pic(pptDetailPair);
        return picStreamList;
    }

    public Pair<InputStream, EnumPptSuffix> checkAddressIsPpt(String pptAddress) throws Exception {
        File file = new File(pptAddress);
        if (!file.exists()) {
            throw new Ppt2PicException(EnumExceptionCode.PPT_ADDRESS_IS_NOT_EXIST);
        }
        EnumPptSuffix enumPptSuffix = EnumPptSuffix.gainEnumBySuffix(this.getExtension(pptAddress));
        return Pair.of((Object)new FileInputStream(file), (Object)((Object)enumPptSuffix));
    }

    public Pair<InputStream, EnumPptSuffix> checkUrlIsPpt(String pptUrl) throws Exception {
        EnumPptSuffix enumPptSuffix = EnumPptSuffix.gainEnumBySuffix(this.getExtension(pptUrl));
        URL url = new URL(pptUrl);
        URLConnection openConnection = url.openConnection();
        InputStream inputStream = openConnection.getInputStream();
        return Pair.of((Object)inputStream, (Object)((Object)enumPptSuffix));
    }

    public List<ByteArrayOutputStream> handlePpt2Pic(Pair<InputStream, EnumPptSuffix> pptDetailPair) throws Exception {
        InputStream inputStream = (InputStream)pptDetailPair.getLeft();
        EnumPptSuffix pptSuffix = (EnumPptSuffix)((Object)pptDetailPair.getRight());
        List<ByteArrayOutputStream> pptPicStreamList = new ArrayList<ByteArrayOutputStream>();
        switch (pptSuffix) {
            case PPT: {
                PptOperate pptOperate = new PptOperate(inputStream);
                pptPicStreamList = pptOperate.gainPptpicStream();
                break;
            }
            case PPTX: {
                PptxOperate pptxOperate = new PptxOperate(inputStream);
                pptPicStreamList = pptxOperate.gainPptpicStream();
                break;
            }
        }
        return pptPicStreamList;
    }

    public void writeStreamToTargetAddress(String targetAddress, EnumPptFrom enumPptFrom) throws Exception {
        this.checkTargetAddress(targetAddress);
        List<ByteArrayOutputStream> picStreamList = this.handlePpt2Pic(enumPptFrom);
        for (ByteArrayOutputStream picStream : picStreamList) {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(picStream.toByteArray()));
            try {
                File picFile = new File(targetAddress + System.currentTimeMillis() + ".png");
                ImageIO.write((RenderedImage)bufferedImage, "png", picFile);
            }
            catch (Exception e) {
                throw new Ppt2PicException(EnumExceptionCode.WRITE_PIC_FAILED);
            }
            finally {
                bufferedImage.flush();
            }
        }
    }

    public void checkTargetAddress(String targetAddress) {
        boolean mkdirs;
        File descDir;
        if (!targetAddress.endsWith(File.separator)) {
            targetAddress = targetAddress + File.separator;
        }
        if (!(descDir = new File(targetAddress)).exists() && (mkdirs = descDir.mkdirs())) {
            throw new Ppt2PicException(EnumExceptionCode.TARGET_ADDRESS_IS_NOT_RIGHT);
        }
    }

    public String getExtension(String fileName) {
        if (fileName == null || fileName.lastIndexOf(".") == -1 || fileName.lastIndexOf(".") == fileName.length() - 1) {
            throw new Ppt2PicException(EnumExceptionCode.PPT_ADDRESS_IS_NOT_RIGHT);
        }
        return StringUtils.lowerCase((String)fileName.substring(fileName.lastIndexOf(".") + 1));
    }
}

