/*
 * Decompiled with CFR 0.152.
 */
package co.com.bancolombia.secretsmanager.connector;

import co.com.bancolombia.secretsmanager.api.GenericManagerAsync;
import co.com.bancolombia.secretsmanager.api.exceptions.SecretException;
import co.com.bancolombia.secretsmanager.commons.utils.GsonUtils;
import co.com.bancolombia.secretsmanager.config.AWSSecretsManagerConfig;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import reactor.cache.CacheMono;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.core.scheduler.Schedulers;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.auth.credentials.WebIdentityTokenFileCredentialsProvider;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;

public class AWSSecretManagerConnectorAsync
implements GenericManagerAsync {
    private final AWSSecretsManagerConfig config;
    private SecretsManagerAsyncClient client;
    private Cache<String, String> cache;
    private Logger logger = Logger.getLogger("connector.AWSSecretManagerConnector");

    public AWSSecretManagerConnectorAsync(AWSSecretsManagerConfig config) {
        this.config = config;
        this.client = this.buildClient();
        this.cache = this.initCache();
    }

    public Mono<String> getSecret(String secretName) {
        return CacheMono.lookup(secret -> Mono.justOrEmpty((Object)this.cache.getIfPresent(secret)).map(Signal::next), (Object)secretName).onCacheMissResume(() -> this.getSecretValue(secretName).subscribeOn(Schedulers.elastic())).andWriteWith((key, signal) -> Mono.fromRunnable(() -> Optional.ofNullable(signal.get()).ifPresent(value -> this.cache.put(key, value))));
    }

    public <T> Mono<T> getSecret(String secretName, Class<T> cls) {
        return this.getSecret(secretName).flatMap(data -> Mono.just((Object)GsonUtils.getInstance().stringToModel(data, cls))).onErrorMap(e -> new SecretException(e.getMessage()));
    }

    private Mono<String> getSecretValue(String secretName) {
        GetSecretValueRequest getSecretValueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build();
        return Mono.fromFuture((CompletableFuture)this.client.getSecretValue(getSecretValueRequest)).switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)new SecretException("Secret value is null")))).flatMap(secretResult -> {
            if (secretResult.secretString() != null) {
                String result = secretResult.secretString();
                return Mono.just((Object)result);
            }
            return Mono.error((Throwable)new SecretException("Secret value is not a String"));
        }).doOnError(err -> this.logger.warning("Error retrieving the secret: " + err.getMessage()));
    }

    private AwsCredentialsProviderChain getProviderChain() {
        return AwsCredentialsProviderChain.builder().addCredentialsProvider((AwsCredentialsProvider)EnvironmentVariableCredentialsProvider.create()).addCredentialsProvider((AwsCredentialsProvider)SystemPropertyCredentialsProvider.create()).addCredentialsProvider((AwsCredentialsProvider)WebIdentityTokenFileCredentialsProvider.create()).addCredentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create()).addCredentialsProvider((AwsCredentialsProvider)ContainerCredentialsProvider.builder().build()).addCredentialsProvider((AwsCredentialsProvider)InstanceProfileCredentialsProvider.create()).build();
    }

    private SecretsManagerAsyncClient buildClient() {
        SecretsManagerAsyncClientBuilder clientBuilder = (SecretsManagerAsyncClientBuilder)((SecretsManagerAsyncClientBuilder)SecretsManagerAsyncClient.builder().credentialsProvider((AwsCredentialsProvider)this.getProviderChain())).region(this.config.getRegion());
        if (!this.config.getEndpoint().equals("")) {
            clientBuilder.endpointOverride(URI.create(this.config.getEndpoint()));
        }
        return (SecretsManagerAsyncClient)clientBuilder.build();
    }

    private Cache<String, String> initCache() {
        return Caffeine.newBuilder().maximumSize((long)this.config.getCacheSize()).expireAfterWrite((long)this.config.getCacheSeconds(), TimeUnit.SECONDS).build();
    }
}

