/*
 * Decompiled with CFR 0.152.
 */
package com.shockwave.pdfium;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.RectF;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.view.Surface;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.util.Size;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class PdfiumCore {
    private static final String TAG = PdfiumCore.class.getName();
    private static final Class FD_CLASS = FileDescriptor.class;
    private static final String FD_FIELD_NAME = "descriptor";
    private static final Object lock;
    private static Field mFdField;
    private int mCurrentDpi;

    private native long nativeOpenDocument(int var1, String var2);

    private native long nativeOpenMemDocument(byte[] var1, String var2);

    private native void nativeCloseDocument(long var1);

    private native int nativeGetPageCount(long var1);

    private native long nativeLoadPage(long var1, int var3);

    private native long[] nativeLoadPages(long var1, int var3, int var4);

    private native void nativeClosePage(long var1);

    private native void nativeClosePages(long[] var1);

    private native int nativeGetPageWidthPixel(long var1, int var3);

    private native int nativeGetPageHeightPixel(long var1, int var3);

    private native int nativeGetPageWidthPoint(long var1);

    private native int nativeGetPageHeightPoint(long var1);

    private native void nativeRenderPage(long var1, Surface var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    private native void nativeRenderPageBitmap(long var1, Bitmap var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    private native String nativeGetDocumentMetaText(long var1, String var3);

    private native Long nativeGetFirstChildBookmark(long var1, Long var3);

    private native Long nativeGetSiblingBookmark(long var1, long var3);

    private native String nativeGetBookmarkTitle(long var1);

    private native long nativeGetBookmarkDestIndex(long var1, long var3);

    private native Size nativeGetPageSizeByIndex(long var1, int var3, int var4);

    private native long[] nativeGetPageLinks(long var1);

    private native Integer nativeGetDestPageIndex(long var1, long var3);

    private native String nativeGetLinkURI(long var1, long var3);

    private native RectF nativeGetLinkRect(long var1);

    private native Point nativePageCoordsToDevice(long var1, int var3, int var4, int var5, int var6, int var7, double var8, double var10);

    public static int getNumFd(ParcelFileDescriptor fdObj) {
        try {
            if (mFdField == null) {
                mFdField = FD_CLASS.getDeclaredField(FD_FIELD_NAME);
                mFdField.setAccessible(true);
            }
            return mFdField.getInt(fdObj.getFileDescriptor());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return -1;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public PdfiumCore(Context ctx) {
        this.mCurrentDpi = ctx.getResources().getDisplayMetrics().densityDpi;
    }

    public PdfDocument newDocument(ParcelFileDescriptor fd) throws IOException {
        return this.newDocument(fd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdfDocument newDocument(ParcelFileDescriptor fd, String password) throws IOException {
        PdfDocument document = new PdfDocument();
        document.parcelFileDescriptor = fd;
        Object object = lock;
        synchronized (object) {
            document.mNativeDocPtr = this.nativeOpenDocument(PdfiumCore.getNumFd(fd), password);
        }
        return document;
    }

    public PdfDocument newDocument(byte[] data) throws IOException {
        return this.newDocument(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdfDocument newDocument(byte[] data, String password) throws IOException {
        PdfDocument document = new PdfDocument();
        Object object = lock;
        synchronized (object) {
            document.mNativeDocPtr = this.nativeOpenMemDocument(data, password);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageCount(PdfDocument doc) {
        Object object = lock;
        synchronized (object) {
            return this.nativeGetPageCount(doc.mNativeDocPtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long openPage(PdfDocument doc, int pageIndex) {
        Object object = lock;
        synchronized (object) {
            long pagePtr = this.nativeLoadPage(doc.mNativeDocPtr, pageIndex);
            doc.mNativePagesPtr.put(pageIndex, pagePtr);
            return pagePtr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] openPage(PdfDocument doc, int fromIndex, int toIndex) {
        Object object = lock;
        synchronized (object) {
            long[] pagesPtr = this.nativeLoadPages(doc.mNativeDocPtr, fromIndex, toIndex);
            int pageIndex = fromIndex;
            for (long page : pagesPtr) {
                if (pageIndex > toIndex) break;
                doc.mNativePagesPtr.put(pageIndex, page);
                ++pageIndex;
            }
            return pagesPtr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageWidth(PdfDocument doc, int index) {
        Object object = lock;
        synchronized (object) {
            Long pagePtr = doc.mNativePagesPtr.get(index);
            if (pagePtr != null) {
                return this.nativeGetPageWidthPixel(pagePtr, this.mCurrentDpi);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageHeight(PdfDocument doc, int index) {
        Object object = lock;
        synchronized (object) {
            Long pagePtr = doc.mNativePagesPtr.get(index);
            if (pagePtr != null) {
                return this.nativeGetPageHeightPixel(pagePtr, this.mCurrentDpi);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageWidthPoint(PdfDocument doc, int index) {
        Object object = lock;
        synchronized (object) {
            Long pagePtr = doc.mNativePagesPtr.get(index);
            if (pagePtr != null) {
                return this.nativeGetPageWidthPoint(pagePtr);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageHeightPoint(PdfDocument doc, int index) {
        Object object = lock;
        synchronized (object) {
            Long pagePtr = doc.mNativePagesPtr.get(index);
            if (pagePtr != null) {
                return this.nativeGetPageHeightPoint(pagePtr);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Size getPageSize(PdfDocument doc, int index) {
        Object object = lock;
        synchronized (object) {
            return this.nativeGetPageSizeByIndex(doc.mNativeDocPtr, index, this.mCurrentDpi);
        }
    }

    public void renderPage(PdfDocument doc, Surface surface, int pageIndex, int startX, int startY, int drawSizeX, int drawSizeY) {
        this.renderPage(doc, surface, pageIndex, startX, startY, drawSizeX, drawSizeY, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderPage(PdfDocument doc, Surface surface, int pageIndex, int startX, int startY, int drawSizeX, int drawSizeY, boolean renderAnnot) {
        Object object = lock;
        synchronized (object) {
            try {
                this.nativeRenderPage(doc.mNativePagesPtr.get(pageIndex), surface, this.mCurrentDpi, startX, startY, drawSizeX, drawSizeY, renderAnnot);
            }
            catch (NullPointerException e) {
                Log.e((String)TAG, (String)"mContext may be null");
                e.printStackTrace();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception throw from native");
                e.printStackTrace();
            }
        }
    }

    public void renderPageBitmap(PdfDocument doc, Bitmap bitmap, int pageIndex, int startX, int startY, int drawSizeX, int drawSizeY) {
        this.renderPageBitmap(doc, bitmap, pageIndex, startX, startY, drawSizeX, drawSizeY, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderPageBitmap(PdfDocument doc, Bitmap bitmap, int pageIndex, int startX, int startY, int drawSizeX, int drawSizeY, boolean renderAnnot) {
        Object object = lock;
        synchronized (object) {
            try {
                this.nativeRenderPageBitmap(doc.mNativePagesPtr.get(pageIndex), bitmap, this.mCurrentDpi, startX, startY, drawSizeX, drawSizeY, renderAnnot);
            }
            catch (NullPointerException e) {
                Log.e((String)TAG, (String)"mContext may be null");
                e.printStackTrace();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception throw from native");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDocument(PdfDocument doc) {
        Object object = lock;
        synchronized (object) {
            for (Integer index : doc.mNativePagesPtr.keySet()) {
                this.nativeClosePage(doc.mNativePagesPtr.get(index));
            }
            doc.mNativePagesPtr.clear();
            this.nativeCloseDocument(doc.mNativeDocPtr);
            if (doc.parcelFileDescriptor != null) {
                try {
                    doc.parcelFileDescriptor.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                doc.parcelFileDescriptor = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdfDocument.Meta getDocumentMeta(PdfDocument doc) {
        Object object = lock;
        synchronized (object) {
            PdfDocument.Meta meta = new PdfDocument.Meta();
            meta.title = this.nativeGetDocumentMetaText(doc.mNativeDocPtr, "Title");
            meta.author = this.nativeGetDocumentMetaText(doc.mNativeDocPtr, "Author");
            meta.subject = this.nativeGetDocumentMetaText(doc.mNativeDocPtr, "Subject");
            meta.keywords = this.nativeGetDocumentMetaText(doc.mNativeDocPtr, "Keywords");
            meta.creator = this.nativeGetDocumentMetaText(doc.mNativeDocPtr, "Creator");
            meta.producer = this.nativeGetDocumentMetaText(doc.mNativeDocPtr, "Producer");
            meta.creationDate = this.nativeGetDocumentMetaText(doc.mNativeDocPtr, "CreationDate");
            meta.modDate = this.nativeGetDocumentMetaText(doc.mNativeDocPtr, "ModDate");
            return meta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PdfDocument.Bookmark> getTableOfContents(PdfDocument doc) {
        Object object = lock;
        synchronized (object) {
            ArrayList<PdfDocument.Bookmark> topLevel = new ArrayList<PdfDocument.Bookmark>();
            Long first = this.nativeGetFirstChildBookmark(doc.mNativeDocPtr, null);
            if (first != null) {
                this.recursiveGetBookmark(topLevel, doc, first);
            }
            return topLevel;
        }
    }

    private void recursiveGetBookmark(List<PdfDocument.Bookmark> tree, PdfDocument doc, long bookmarkPtr) {
        Long sibling;
        PdfDocument.Bookmark bookmark = new PdfDocument.Bookmark();
        bookmark.mNativePtr = bookmarkPtr;
        bookmark.title = this.nativeGetBookmarkTitle(bookmarkPtr);
        bookmark.pageIdx = this.nativeGetBookmarkDestIndex(doc.mNativeDocPtr, bookmarkPtr);
        tree.add(bookmark);
        Long child = this.nativeGetFirstChildBookmark(doc.mNativeDocPtr, bookmarkPtr);
        if (child != null) {
            this.recursiveGetBookmark(bookmark.getChildren(), doc, child);
        }
        if ((sibling = this.nativeGetSiblingBookmark(doc.mNativeDocPtr, bookmarkPtr)) != null) {
            this.recursiveGetBookmark(tree, doc, sibling);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PdfDocument.Link> getPageLinks(PdfDocument doc, int pageIndex) {
        Object object = lock;
        synchronized (object) {
            long[] linkPtrs;
            ArrayList<PdfDocument.Link> links = new ArrayList<PdfDocument.Link>();
            for (long linkPtr : linkPtrs = this.nativeGetPageLinks(doc.mNativePagesPtr.get(pageIndex))) {
                Integer index = this.nativeGetDestPageIndex(doc.mNativeDocPtr, linkPtr);
                String uri = this.nativeGetLinkURI(doc.mNativeDocPtr, linkPtr);
                RectF rect = this.nativeGetLinkRect(linkPtr);
                if (rect == null || index == null && uri == null) continue;
                links.add(new PdfDocument.Link(rect, index, uri));
            }
            return links;
        }
    }

    public Point mapPageCoordsToDevice(PdfDocument doc, int pageIndex, int startX, int startY, int sizeX, int sizeY, int rotate, double pageX, double pageY) {
        long pagePtr = doc.mNativePagesPtr.get(pageIndex);
        return this.nativePageCoordsToDevice(pagePtr, startX, startY, sizeX, sizeY, rotate, pageX, pageY);
    }

    public RectF mapRectToDevice(PdfDocument doc, int pageIndex, int startX, int startY, int sizeX, int sizeY, int rotate, RectF coords) {
        Point leftTop = this.mapPageCoordsToDevice(doc, pageIndex, startX, startY, sizeX, sizeY, rotate, coords.left, coords.top);
        Point rightBottom = this.mapPageCoordsToDevice(doc, pageIndex, startX, startY, sizeX, sizeY, rotate, coords.right, coords.bottom);
        return new RectF((float)leftTop.x, (float)leftTop.y, (float)rightBottom.x, (float)rightBottom.y);
    }

    static {
        try {
            System.loadLibrary("modpng");
            System.loadLibrary("modft2");
            System.loadLibrary("modpdfium");
            System.loadLibrary("jniPdfium");
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)TAG, (String)("Native libraries failed to load - " + e));
        }
        lock = new Object();
        mFdField = null;
    }
}

