/*
 * Decompiled with CFR 0.152.
 */
package com.bastiaanjansen.jwt;

import com.bastiaanjansen.jwt.ClaimConverter;
import com.bastiaanjansen.jwt.utils.Base64Utils;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class Claims {
    private final Registered[] registeredDateClaims = new Registered[]{Registered.EXPIRATION_TIME, Registered.ISSUED_AT, Registered.NOT_BEFORE};
    protected final Map<String, Object> claims = new HashMap<String, Object>();

    protected Claims() {
    }

    public boolean containsClaim(String name) {
        return this.claims.containsKey(name);
    }

    public Map<String, Object> getAsMap() {
        return new HashMap<String, Object>(this.claims);
    }

    public String base64Encoded() {
        String json = new JSONObject(this.claims).toString();
        return Base64Utils.encodeBase64URL(json);
    }

    public <T> T getClaim(String name, Class<T> type) {
        Object value = this.claims.get(name);
        boolean isDateClaim = Arrays.stream(this.registeredDateClaims).map(Registered::getValue).collect(Collectors.toList()).contains(name);
        if (isDateClaim) {
            long millisSinceEpoch = Long.parseLong(String.valueOf(value));
            return (T)new Date(millisSinceEpoch);
        }
        return type.cast(value);
    }

    public <T> T getClaim(String name, ClaimConverter<T> converter) {
        Object value = this.claims.get(name);
        return converter.convert(value);
    }

    public void addClaim(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.claims.put(name, value);
    }

    public static enum Registered {
        ISSUER("iss"),
        SUBJECT("sub"),
        AUDIENCE("aud"),
        EXPIRATION_TIME("exp"),
        NOT_BEFORE("nbf"),
        ISSUED_AT("iat"),
        JWT_ID("jti"),
        TYPE("typ"),
        CONTENT_TYPE("cty"),
        ALGORITHM("alg");

        private final String value;

        private Registered(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

