/*
 * Decompiled with CFR 0.152.
 */
package com.bastiaanjansen.jwt;

import com.bastiaanjansen.jwt.ClaimValidator;
import com.bastiaanjansen.jwt.Claims;
import com.bastiaanjansen.jwt.JWT;
import com.bastiaanjansen.jwt.JWTValidator;
import com.bastiaanjansen.jwt.Payload;
import com.bastiaanjansen.jwt.exceptions.JWTExpiredException;
import com.bastiaanjansen.jwt.exceptions.JWTValidationException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DefaultJWTValidator
implements JWTValidator {
    private final Map<String, ClaimValidator> headerValidators;
    private final Map<String, ClaimValidator> payloadValidators;

    public DefaultJWTValidator() {
        this(new Builder().withType("JWT"));
    }

    public DefaultJWTValidator(Builder builder) {
        this.headerValidators = builder.headerValidators;
        this.payloadValidators = builder.payloadValidators;
    }

    @Override
    public void validate(JWT jwt) throws JWTValidationException {
        this.validateAlgorithm(jwt);
        this.verifyValidators(jwt.getHeader().getAsMap(), this.headerValidators);
        this.verifyPayload(jwt.getPayload());
    }

    private void validateAlgorithm(JWT jwt) throws JWTValidationException {
        String concatenated = String.format("%s.%s", jwt.getHeader().base64Encoded(), jwt.getPayload().base64Encoded());
        byte[] concatenatedBytes = concatenated.getBytes(StandardCharsets.UTF_8);
        if (!jwt.getAlgorithm().verify(concatenatedBytes, Base64.getUrlDecoder().decode(jwt.getSignature()))) {
            throw new JWTValidationException("Signature is not valid");
        }
    }

    private void verifyValidators(Map<String, Object> map, Map<String, ClaimValidator> validators) throws JWTValidationException {
        for (Map.Entry<String, ClaimValidator> validatorEntry : validators.entrySet()) {
            String key = validatorEntry.getKey();
            ClaimValidator validator = validatorEntry.getValue();
            if (!map.containsKey(key)) {
                throw new JWTValidationException(key + " is not present in payload");
            }
            if (map.get(key) == null) {
                throw new JWTValidationException(key + " is null");
            }
            if (validator.validate(map.get(key))) continue;
            throw new JWTValidationException(key + " does not conform to constraint");
        }
    }

    private void verifyPayload(Payload payload) throws JWTValidationException {
        Date currentDate = new Date();
        this.validateExpirationTime(payload, currentDate);
        this.validateNotBefore(payload, currentDate);
        this.verifyValidators(payload.getAsMap(), this.payloadValidators);
    }

    private void validateNotBefore(Payload payload, Date currentDate) throws JWTValidationException {
        if (payload.containsClaim(Claims.Registered.NOT_BEFORE.getValue())) {
            Date notBefore = payload.getNotBefore();
            if (currentDate.getTime() <= notBefore.getTime()) {
                throw new JWTValidationException("JWT is only valid after " + notBefore);
            }
        }
    }

    private void validateExpirationTime(Payload payload, Date currentDate) throws JWTExpiredException {
        if (payload.containsClaim(Claims.Registered.EXPIRATION_TIME.getValue())) {
            Date expirationTime = payload.getExpirationTime();
            if (currentDate.getTime() > expirationTime.getTime()) {
                throw new JWTExpiredException("JWT expired on " + expirationTime);
            }
        }
    }

    public Map<String, ClaimValidator> getHeaderValidators() {
        return new HashMap<String, ClaimValidator>(this.headerValidators);
    }

    public Map<String, ClaimValidator> getPayloadValidators() {
        return new HashMap<String, ClaimValidator>(this.payloadValidators);
    }

    public static class Builder {
        private final Map<String, ClaimValidator> headerValidators = new HashMap<String, ClaimValidator>();
        private final Map<String, ClaimValidator> payloadValidators = new HashMap<String, ClaimValidator>();

        public Builder withType(String type) {
            this.withHeader(Claims.Registered.TYPE.getValue(), type::equals);
            return this;
        }

        public Builder withContentType(String type) {
            this.withHeader(Claims.Registered.CONTENT_TYPE.getValue(), type::equals);
            return this;
        }

        public Builder withAlgorithm(String algorithm) {
            this.withHeader(Claims.Registered.ALGORITHM.getValue(), algorithm::equals);
            return this;
        }

        public Builder withIssuer(String issuer) {
            this.withClaim(Claims.Registered.ISSUER.getValue(), issuer::equals);
            return this;
        }

        public Builder withSubject(String subject) {
            this.withClaim(Claims.Registered.SUBJECT.getValue(), subject::equals);
            return this;
        }

        public Builder withOneOfAudience(String ... audience) {
            this.withClaim(Claims.Registered.AUDIENCE.getValue(), (Object value) -> {
                for (String audienceItem : audience) {
                    if (!Arrays.asList((Object[])value).contains(audienceItem)) continue;
                    return true;
                }
                return false;
            });
            return this;
        }

        public Builder withAllOfAudience(String ... audience) {
            this.withClaim(Claims.Registered.AUDIENCE.getValue(), (Object value) -> {
                String[] values = (String[])value;
                return Arrays.asList(values).containsAll(Arrays.asList(audience));
            });
            return this;
        }

        public Builder withExpirationTime(Date expirationTime) {
            this.withClaim(Claims.Registered.EXPIRATION_TIME.getValue(), (Object value) -> value.equals(expirationTime.getTime()));
            return this;
        }

        public Builder withExpirationTime(long timeSinceEpoch) {
            this.withClaim(Claims.Registered.EXPIRATION_TIME.getValue(), (Object value) -> value.equals(timeSinceEpoch));
            return this;
        }

        public Builder withNotBefore(Date notBefore) {
            this.withClaim(Claims.Registered.NOT_BEFORE.getValue(), (Object value) -> value.equals(notBefore.getTime()));
            return this;
        }

        public Builder withNotBefore(long timeSinceEpoch) {
            this.withClaim(Claims.Registered.NOT_BEFORE.getValue(), (Object value) -> value.equals(timeSinceEpoch));
            return this;
        }

        public Builder withIssuedAt(Date issuedAt) {
            this.withClaim(Claims.Registered.ISSUED_AT.getValue(), (Object value) -> value.equals(issuedAt.getTime()));
            return this;
        }

        public Builder withIssuedAt(long timeSinceEpoch) {
            this.withClaim(Claims.Registered.ISSUED_AT.getValue(), (Object value) -> value.equals(timeSinceEpoch));
            return this;
        }

        public Builder withID(String id) {
            this.withClaim(Claims.Registered.JWT_ID.getValue(), id::equals);
            return this;
        }

        public Builder withHeader(String name, Object value) {
            this.withHeader(name, value::equals);
            return this;
        }

        public Builder withHeader(String name, ClaimValidator validator) {
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            if (validator == null) {
                throw new IllegalArgumentException("validator cannot be null");
            }
            this.headerValidators.put(name, validator);
            return this;
        }

        public Builder withClaim(String name, Object value) {
            this.withClaim(name, value::equals);
            return this;
        }

        public Builder withClaim(String name, ClaimValidator validator) {
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            if (validator == null) {
                throw new IllegalArgumentException("validator cannot be null");
            }
            this.payloadValidators.put(name, validator);
            return this;
        }

        public DefaultJWTValidator build() {
            return new DefaultJWTValidator(this);
        }
    }
}

