/*
 * Decompiled with CFR 0.152.
 */
package com.bastiaanjansen.jwt;

import com.bastiaanjansen.jwt.Claims;
import com.bastiaanjansen.jwt.utils.Base64Utils;
import java.util.Map;
import org.json.JSONObject;

public final class Header
extends Claims {
    public Header() {
        this.setType("JWT");
    }

    public Header(Map<String, Object> map) {
        this();
        this.claims.putAll(map);
    }

    public static Header fromBase64EncodedJSON(String encodedJSON) {
        String decodedJSON = Base64Utils.decodeBase64URL(encodedJSON);
        Map map = new JSONObject(decodedJSON).toMap();
        return new Header(map);
    }

    public void setType(String type) {
        this.addClaim(Claims.Registered.TYPE.getValue(), type);
    }

    public String getType() {
        return this.getClaim(Claims.Registered.TYPE.getValue(), String.class);
    }

    public void setContentType(String value) {
        this.addClaim(Claims.Registered.CONTENT_TYPE.getValue(), value);
    }

    public String getContentType() {
        return this.getClaim(Claims.Registered.CONTENT_TYPE.getValue(), String.class);
    }

    public void setAlgorithm(String algorithm) {
        this.addClaim(Claims.Registered.ALGORITHM.getValue(), algorithm);
    }

    public String getAlgorithm() {
        return this.getClaim(Claims.Registered.ALGORITHM.getValue(), String.class);
    }
}

