/*
 * Decompiled with CFR 0.152.
 */
package com.bastiaanjansen.jwt;

import com.bastiaanjansen.jwt.Claims;
import com.bastiaanjansen.jwt.DefaultJWTValidator;
import com.bastiaanjansen.jwt.Header;
import com.bastiaanjansen.jwt.JWTValidator;
import com.bastiaanjansen.jwt.Payload;
import com.bastiaanjansen.jwt.algorithms.Algorithm;
import com.bastiaanjansen.jwt.exceptions.JWTCreationException;
import com.bastiaanjansen.jwt.exceptions.JWTDecodeException;
import com.bastiaanjansen.jwt.exceptions.JWTSignException;
import com.bastiaanjansen.jwt.exceptions.JWTValidationException;
import com.bastiaanjansen.jwt.utils.Base64Utils;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import org.json.JSONException;

public final class JWT {
    private static final int NUMBER_OF_SEGMENTS = 3;
    private final Algorithm algorithm;
    private final Header header;
    private final Payload payload;
    private final String signature;

    public JWT(Algorithm algorithm, Header header, Payload payload) throws JWTCreationException {
        this.algorithm = algorithm;
        this.header = header;
        this.payload = payload;
        this.signature = this.createSignature();
    }

    private JWT(Algorithm algorithm, Header header, Payload payload, String signature) {
        this.algorithm = algorithm;
        this.header = header;
        this.payload = payload;
        this.signature = signature;
    }

    private JWT(Builder builder) throws JWTCreationException {
        this.algorithm = builder.algorithm;
        this.payload = builder.payload;
        this.header = builder.header;
        this.signature = this.createSignature();
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public Header getHeader() {
        return this.header;
    }

    public String getSignature() {
        return this.signature;
    }

    public static JWT fromRawJWT(Algorithm algorithm, String jwt) throws JWTDecodeException, JWTCreationException {
        String[] segments = jwt.split("\\.");
        if (segments.length != 3) {
            throw new JWTDecodeException("The number of segments must be 3");
        }
        try {
            Header header = Header.fromBase64EncodedJSON(segments[0]);
            Payload payload = Payload.fromBase64EncodedJSON(segments[1]);
            String signature = segments[2];
            if (!header.getAlgorithm().equals(algorithm.getName())) {
                throw new JWTCreationException("Algorithm defined in header does not match " + algorithm.getName());
            }
            return new JWT(algorithm, header, payload, signature);
        }
        catch (IllegalArgumentException | JSONException e) {
            throw new JWTDecodeException("Error decoding JWT");
        }
    }

    public void validate(JWTValidator validator) throws JWTValidationException {
        validator.validate(this);
    }

    public void validate() throws JWTValidationException {
        this.validate(new DefaultJWTValidator());
    }

    public String sign() throws JWTCreationException {
        String signature = this.createSignature();
        return String.format("%s.%s.%s", this.header.base64Encoded(), this.payload.base64Encoded(), signature);
    }

    private String createSignature() throws JWTCreationException {
        try {
            String concatenated = String.format("%s.%s", this.header.base64Encoded(), this.payload.base64Encoded());
            byte[] signed = this.algorithm.sign(concatenated.getBytes(StandardCharsets.UTF_8));
            return Base64Utils.encodeBase64URL(signed);
        }
        catch (JWTSignException e) {
            throw new JWTCreationException(e.getMessage());
        }
    }

    public static class Builder {
        private final Algorithm algorithm;
        private Header header;
        private Payload payload;

        public Builder(Algorithm algorithm) {
            if (algorithm == null) {
                throw new IllegalArgumentException("Algorithm must not be null");
            }
            this.algorithm = algorithm;
            this.header = new Header();
            this.payload = new Payload();
            this.header.setAlgorithm(algorithm.getName());
        }

        public Builder withType(String type) {
            this.header.setType(type);
            return this;
        }

        public Builder withContentType(String contentType) {
            this.header.setContentType(contentType);
            return this;
        }

        public Builder withIssuer(String issuer) {
            this.payload.setIssuer(issuer);
            return this;
        }

        public Builder withSubject(String subject) {
            this.payload.setSubject(subject);
            return this;
        }

        public Builder withAudience(String ... audience) {
            this.payload.setAudience(audience);
            return this;
        }

        public Builder withExpirationTime(Date expirationTime) {
            this.payload.setExpirationTime(expirationTime);
            return this;
        }

        public Builder withExpirationTime(long timeSinceEpoch) {
            this.payload.setExpirationTime(timeSinceEpoch);
            return this;
        }

        public Builder withNotBefore(Date notBefore) {
            this.payload.setNotBefore(notBefore);
            return this;
        }

        public Builder withNotBefore(long timeSinceEpoch) {
            this.payload.setNotBefore(timeSinceEpoch);
            return this;
        }

        public Builder withIssuedAt(Date issuedAt) {
            this.payload.setIssuedAt(issuedAt);
            return this;
        }

        public Builder withIssuedAt(long timeSinceEpoch) {
            this.payload.setIssuedAt(timeSinceEpoch);
            return this;
        }

        public Builder withID(String id) {
            this.payload.setID(id);
            return this;
        }

        public Builder withHeader(String name, String value) {
            if (name == null || value == null) {
                throw new IllegalArgumentException("Header value cannot be null");
            }
            this.header.addClaim(name, value);
            return this;
        }

        public Builder withHeader(Header header) {
            if (header == null) {
                throw new IllegalArgumentException("Header cannot be null");
            }
            this.header = header;
            return this;
        }

        public Builder withPayload(Payload payload) {
            if (payload == null) {
                throw new IllegalArgumentException("Payload cannot be null");
            }
            this.payload = payload;
            return this;
        }

        public Builder withClaim(String name, Object value) {
            if (name == null || value == null) {
                throw new IllegalArgumentException("Claim value cannot be null");
            }
            this.payload.addClaim(name, value);
            return this;
        }

        public Builder withClaim(Map<String, ?> claims) {
            for (Map.Entry<String, ?> claim : claims.entrySet()) {
                this.withClaim(claim.getKey(), claim.getValue());
            }
            return this;
        }

        public String sign() throws JWTCreationException {
            if (!this.header.containsClaim(Claims.Registered.TYPE.getValue())) {
                this.withType("JWT");
            }
            return new JWT(this).sign();
        }

        public String sign(Map<String, ?> payload) throws JWTCreationException {
            this.withClaim(payload);
            return this.sign();
        }

        public JWT build() throws JWTCreationException {
            return new JWT(this);
        }
    }
}

