/*
 * Decompiled with CFR 0.152.
 */
package com.bastiaanjansen.jwt;

import com.bastiaanjansen.jwt.Claims;
import com.bastiaanjansen.jwt.utils.Base64Utils;
import java.util.Date;
import java.util.Map;
import org.json.JSONObject;

public final class Payload
extends Claims {
    public Payload() {
    }

    public Payload(Map<String, Object> map) {
        this.claims.putAll(map);
    }

    public static Payload fromBase64EncodedJSON(String encodedJSON) {
        String decodedJSON = Base64Utils.decodeBase64URL(encodedJSON);
        Map map = new JSONObject(decodedJSON).toMap();
        return new Payload(map);
    }

    public void setIssuer(String issuer) {
        this.addClaim(Claims.Registered.ISSUER.getValue(), issuer);
    }

    public String getIssuer() {
        return this.getClaim(Claims.Registered.ISSUER.getValue(), String.class);
    }

    public void setSubject(String subject) {
        this.addClaim(Claims.Registered.SUBJECT.getValue(), subject);
    }

    public String getSubject() {
        return this.getClaim(Claims.Registered.SUBJECT.getValue(), String.class);
    }

    public void setAudience(String ... audience) {
        this.addClaim(Claims.Registered.AUDIENCE.getValue(), audience);
    }

    public String[] getAudience() {
        Object audience = this.getClaim(Claims.Registered.AUDIENCE.getValue(), Object.class);
        if (!(audience instanceof Object[])) {
            return new String[]{(String)audience};
        }
        return (String[])audience;
    }

    public void setExpirationTime(long timeSinceEpoch) {
        this.addClaim(Claims.Registered.EXPIRATION_TIME.getValue(), timeSinceEpoch);
    }

    public void setExpirationTime(Date expirationTime) {
        this.setExpirationTime(expirationTime.getTime());
    }

    public Date getExpirationTime() {
        return this.getClaim(Claims.Registered.EXPIRATION_TIME.getValue(), Date.class);
    }

    public void setNotBefore(long timeSinceEpoch) {
        this.addClaim(Claims.Registered.NOT_BEFORE.getValue(), timeSinceEpoch);
    }

    public void setNotBefore(Date notBefore) {
        this.setNotBefore(notBefore.getTime());
    }

    public Date getNotBefore() {
        return this.getClaim(Claims.Registered.NOT_BEFORE.getValue(), Date.class);
    }

    public void setIssuedAt(long timeSinceEpoch) {
        this.addClaim(Claims.Registered.ISSUED_AT.getValue(), timeSinceEpoch);
    }

    public void setIssuedAt(Date issuedAt) {
        this.setIssuedAt(issuedAt.getTime());
    }

    public Date getIssuedAt() {
        return this.getClaim(Claims.Registered.ISSUED_AT.getValue(), Date.class);
    }

    public void setID(String id) {
        this.addClaim(Claims.Registered.JWT_ID.getValue(), id);
    }

    public String getID() {
        return this.getClaim(Claims.Registered.JWT_ID.getValue(), String.class);
    }
}

