/*
 * Decompiled with CFR 0.152.
 */
package com.bastiaanjansen.jwt.algorithms;

import com.bastiaanjansen.jwt.algorithms.Algorithm;
import com.bastiaanjansen.jwt.exceptions.JWTSignException;
import com.bastiaanjansen.jwt.exceptions.JWTValidationException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMACAlgorithm
extends Algorithm {
    private final byte[] secret;

    HMACAlgorithm(String name, String description, byte[] secret) {
        super(name, description);
        this.secret = secret;
    }

    @Override
    public byte[] sign(String data) throws JWTSignException {
        return this.sign(data.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public byte[] sign(byte[] data) throws JWTSignException {
        try {
            Mac mac = Mac.getInstance(this.description);
            SecretKeySpec secretKey = new SecretKeySpec(this.secret, this.description);
            mac.init(secretKey);
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new JWTSignException(e.getMessage());
        }
    }

    @Override
    public boolean verify(byte[] data, byte[] expected) throws JWTValidationException {
        try {
            byte[] signed = this.sign(data);
            return Arrays.equals(signed, expected);
        }
        catch (JWTSignException e) {
            throw new JWTValidationException(e.getMessage());
        }
    }
}

